#! /bin/bash

#
#  Purpose:
#
#    A bash shell is used to ideal strength, GSFE or universal binding energy in batches, 
#    three examples are including
#
#  Record of vevisions:
#      Data         Programmer        Description of change
#      ====         ==========        =====================
#   2017/03/17      Shihao Zhang      Original code
#
#  Variables:
#
#
#
#
#
#  Note:
#
#    A directory named "FILE" is needed including "${file}" file and "structure" directory. And the 
#    structure files to calculate are including in the "structure" directory
#
#
#
#

# The file name of bash shell that realizes the pre-processing, first-principles calculations
#   and post-processing. Such as /example/example_affine.sh for affine deformation and 
#   /example/example_alias.sh for alias deformation

	file='example_affine.sh'
	#file='example_alias.sh'

#>>> EXAMPLE 1

# The name of structure file to calculated

	structure_file='diamond'

# The slip system, rotation angle or new lattice vector to calculate

for loop in '1 1 1 1 1 -2' '1 1 1 -1 -1 2'
#for loop in '10.00 0.00 0.00' '20.00 0.00 0.00'
#for loop in '0.5 -0.5 0.0 0.5 0.5 -1.0 1.0 1.0 1.0'
do

	# Create directories and copy the structure file to the corresponding directory

	loop_non=$(echo ${loop} | sed 's/\s\+/_/g')
	mkdir ${loop_non}
	mkdir ./${loop_non}/structure
	cp ./FILE/structure/${structure_file}.vasp ./${loop_non}/structure/

	# Substitute the character of "slip system", "rotation angle" or "new lattice vector" in file 
	#   "./FILE/${file}" using "${loop}"

	sed "s/pvh pvk pvl uvu uvv uvw/${loop}/" ./FILE/${file} > ./${loop_non}/${file}
	#sed "s/angx angy angz/${loop}/" ./FILE/${file} > ./${loop_non}/${file}
	#sed "s/vect11 vect12 vect13 vect21 vect22 vect23 vect31 vect32 vect33/${loop}/" ./FILE/${file} > ./${loop_non}/${file}

	# To submit job

	cd ${loop_non}
	chmod +x ${file}
	qsub ${file}
	cd ..

done

#>>> END of EXAMPLE 1


#>>> EXAMPLE 2

# The name of structure file to calculated

for loop in diamond graphene
do

	# Create directories and copy the structure file to the corresponding directory

	mkdir ${loop}
	mkdir ./${loop}/structure
	cp ./FILE/structure/${loop}.vasp ./${loop}/structure/

	# Substitute the character "structure_file" in file "./FILE/${file}" using "${loop}"

	sed "s/structure_file/${loop}/" ./FILE/${file} > ./${loop}/${file}

	# To submit job

	cd ${loop}
	chmod +x ${file}
	qsub ${file}
	cd ..
end

#>>> END fo EXAMPLE 2


#>>> EXAMPLE 3

# The name of structure file (from POS_001 to POS_100) to calculated

for loop in `seq -w 001 001 100`
do

	# Create directories and copy the structure file to the corresponding directory

	mkdir POS_${loop}
	mkdir ./POS_${loop}/structure
	cp ./FILE/structure/POS_${loop}.vasp ./POS_${loop}/structure/

	# Substitute the character "structure_file" in file "./FILE/${file}" using "${loop}"

	sed "s/structure_file/POS_${loop}/" ./FILE/${file} > ./POS_${loop}/${file}

	# To submit job

	cd POS_${loop}
	chmod +x ${file}
	qsub ${file}
	cd ..
 
done

#>>> END of EXAMPLE 3
