#! /bin/bash

#
#  Purpose:
#
#
#  Record of vevisions:
#      Data         Programmer        Description of change
#      ====         ==========        =====================
#   2017/03/17      Shihao Zhang      Original code
#
#  Variables:
#
#    ADAIS_DIR : The path of the source code of ADAIS
#    VASP_DIR  : The path of the compiled VASP
#    POT_DIR   : The path of the POTCAR file
#
#
#

ADAIS_DIR='/home/zrfcms06/code/ADAIS'
VASP_DIR='/home/zrfcms06/code/ADAIS/bin'
POT_DIR='/home/zrfcms06/POTLDA'

for SYS_name in graphene
do

#>>> create POTCAR file
	
	cat ${POT_DIR}/POT_6 > ./POTCAR

#>>> create INCAR file using ADAIS and the file incar_rlx and incar_stc are created

	#>>> the pressure in 0GPa (default value)
	${ADAIS_DIR}/bin/ADAIS --incar -rlx
	#${ADAIS_DIR}/bin/ADAIS --incar -stc

	#>>> and the pressure is 100GPa
	#${ADAIS_DIR}/bin/ADAIS --incar -rlx 100
	#${ADAIS_DIR}/bin/ADAIS --incar -stc 100
	cp incarx INCAR

#>>> project the lattice

	cp ./structure/${SYS_name}.vasp ./INPOS
	#${ADAIS_DIR}/ADAIS --ieee
	#cp RECPOS INPOS

	#${ADAIS_DIR}/bin/ADAIS --proj -mat mat11 mat12 mat13 mat21 mat22 mat23 mat31 mat32 mat33
	${ADAIS_DIR}/bin/ADAIS --proj -rot 0.00 0.00 90.00
	#${ADAIS_DIR}/bin/ADAIS --proj -ind 1 1 1 1 1 -2
	cp PROJPOS AFFPOS0

#>>> create KPOINTS file using ADAIS and the file NEWKPT are created

	cp PROJPOS INPOS
	#>>> kmesh=10x10x10 with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	${ADAIS_DIR}/bin/ADAIS --kpt -kmesh 20 20 1 Gamma

	#>>> KPPRA=1000(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kppra 8000 Gamma

	#>>> KSPACING=0.5(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kspac 0.5 Gamma
	cp NEWKPT KPOINTS

while ((1))
do

rm AFFPOSI
${ADAIS_DIR}/bin/ADAIS --affine -unia2d 1.0000 0.0000 0.0000 0.0100 42
#${ADAIS_DIR}/bin/ADAIS -affine -unia2d ten_str shear_str istr0 step_length step_num -disturbing distance dxx dyy dzz

if [ -s AFFPOSI ]; then
	cp AFFPOSI POSCAR
else
	break
fi

# To set up the iteration
for Niter in {1..6} # 6-maximum iteration number
do

	# To run VASP  
	if [ -s INCAR ] && [ -s POSCAR ] && [ -s KPOINTS ] && [ -s POTCAR ]; then
	        ${VASP_DIR}/vasp_2d_uniaxial >> olog.vasp
	else
	        echo "Necessary files: INCAR POSCAR KPOINTS or POTCAR is not ready!!"
	        continue
	fi

	# To check the convergence for termination
	
	fconv_indx=$(${ADAIS_DIR}/bin/ADAIS --fconv)
	if [ ${fconv_indx} -eq 1 ] || [ ${Niter} -gt 5 ]; then

		# To generate results
		if [ -s OUTCAR ]; then
			${ADAIS_DIR}/bin/ADAIS --output
		else
			echo "OUTCAR does not exist or is empty"
		fi
		break

	else
		cp CONTCAR POSCAR
	fi

# To end up the iteration	
done	

done

${ADAIS_DIR}/bin/ADAIS --bond 1.8000

done

#rm POSCAR KPOINTS* INCAR* POTCAR
#rm CHG* CONTCAR DOSCAR OSZICAR OUTCAR EIGENVAL PCDAT WAVECAR XDATCAR IBZKPT openmpi.log vasprun.xml

#>>> make clean
#${ADAIS_DIR}/bin/ADAIS --clean

#END
