#! /bin/bash

#
#  Purpose:
#
#
#  Record of vevisions:
#      Data         Programmer        Description of change
#      ====         ==========        =====================
#   2017/03/17      Shihao Zhang      Original code
#
#  Variables:
#
#    ADAIS_DIR : The path of the source code of ADAIS
#    VASP_DIR  : The path of the compiled VASP
#    POT_DIR   : The path of the POTCAR file
#
#
#

ADAIS_DIR='/home/zrfcms06/code/ADAIS'
VASP_DIR='/home/zrfcms06/code/ADAIS/bin'
POT_DIR='/home/zrfcms06/POTLDA'

for SYS_name in diamond
do

#>>> create POTCAR file
	
	cat ${POT_DIR}/POT_6 > ./POTCAR

#>>> create INCAR file using ADAIS and the file incar_rlx and incar_stc are created

	#>>> the pressure in 0GPa (default value)
	#${ADAIS_DIR}/bin/ADAIS --incar -rlx
	${ADAIS_DIR}/bin/ADAIS --incar -stc

	#>>> and the pressure is 100GPa
	#${ADAIS_DIR}/bin/ADAIS --incar -rlx 100
	#${ADAIS_DIR}/bin/ADAIS --incar -stc 100
	cp incarx INCAR

#>>> redefine the lattice

	cp ./structure/${SYS_name}.vasp ./INPOS
	#${ADAIS_DIR}/bin/ADAIS --ieee
	#cp RECPOS INPOS
	
	${ADAIS_DIR}/bin/ADAIS --newlat 0.5 -0.5 0.0 0.5 0.5 -1.0 1.0 1.0 1.0

	#cp REDPOS INPOS
	#${ADAIS_DIR}/bin/ADAIS --super sup_1 sup_2 sup_3

	cp SUPPOS ALIPOS0

#>>> create KPOINTS file using ADAIS and the file NEWKPT are created

	cp SUPPOS INPOS
	#>>> kmesh=10x10x10 with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kmesh 10 10 10 Gamma

	#>>> KPPRA=1000(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	${ADAIS_DIR}/bin/ADAIS --kpt -kppra 8000 Gamma

	#>>> KSPACING=0.5(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kspac 0.5 Gamma
	cp NEWKPT KPOINTS

while ((1))
do

	rm ALIPOSI
	${ADAIS_DIR}/bin/ADAIS --alias -dxy3d 0.0000 1.0001 0.0500 0.0000 0.0000 0.0000 7.5
	#${ADAIS_DIR}/bin/ADAIS --alias -dxy2d istart iend ispacing istart iend ispacing zvalue
	#${ADAIS_DIR}/bin/ADAIS --alias -dz istart iend ispacing zvalue
	
	if [ -s ALIPOSI ]; then
		cp ALIPOSI POSCAR
	else
		break
	fi

	# To run VASP  
	if [ -s INCAR ] && [ -s POSCAR ] && [ -s KPOINTS ] && [ -s POTCAR ]; then
	        ${VASP_DIR}/vasp >> olog.vasp
	else
	        echo "Necessary files: INCAR POSCAR KPOINTS or POTCAR is not ready!!"
	        continue
	fi

	# To generate results
	if [ -s OUTCAR ]; then
		${ADAIS_DIR}/bin/ADAIS --output
	else
		echo "OUTCAR does not exist or is empty"
	fi

done
done

#rm POSCAR KPOINTS* INCAR* POTCAR
#rm CHG* CONTCAR DOSCAR OSZICAR OUTCAR EIGENVAL PCDAT WAVECAR XDATCAR IBZKPT vasprun.xml

#>>> make clean
#${ADAIS_DIR}/bin/ADAIS --clean

#END

