#! /bin/bash

#
#  Purpose:
#
#
#  Record of vevisions:
#      Data         Programmer        Description of change
#      ====         ==========        =====================
#   2017/03/17      Shihao Zhang      Original code
#
#  Variables:
#
#    ADAIS_DIR : The path of the source code of ADAIS
#    VASP_DIR  : The path of the compiled VASP
#    POT_DIR   : The path of the POTCAR file
#
#
#

ADAIS_DIR=''
VASP_DIR=''
POT_DIR=''

for SYS_name in structure_file
do

#>>> create POTCAR file
	
	cat ${POT_DIR}/POT_xxx > ./POTCAR

#>>> create INCAR file using ADAIS and the file incar_rlx and incar_stc are created

	#>>> the pressure in 0 GPa (default value)
	${ADAIS_DIR}/bin/ADAIS --incar -rlx
	#${ADAIS_DIR}/bin/ADAIS --incar -stc

	#>>> and the pressure is 100 GPa
	#${ADAIS_DIR}/bin/ADAIS --incar -rlx 100
	#${ADAIS_DIR}/bin/ADAIS --incar -stc 100
	cp incarx INCAR

#>>> project the lattice

	cp ./structure/${SYS_name}.vasp ./INPOS
	#${ADAIS_DIR}/ADAIS --ieee -3d
	#${ADAIS_DIR}/ADAIS --ieee -2d
	#cp IEEEPOS INPOS

	#${ADAIS_DIR}/bin/ADAIS --proj -mat mat11 mat12 mat13 mat21 mat22 mat23 mat31 mat32 mat33
	#${ADAIS_DIR}/bin/ADAIS --proj -rot angx angy angz
	${ADAIS_DIR}/bin/ADAIS --proj -ind pvh pvk pvl uvu uvv uvw
	cp PROJPOS AFFPOS0

#>>> create KPOINTS file using ADAIS and the file NEWKPT are created

	cp PROJPOS INPOS
	#>>> kmesh=10x10x10 with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kmesh 10 10 10 Gamma

	#>>> KPPRA=1000(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	${ADAIS_DIR}/bin/ADAIS --kpt -kppra 1000 Gamma

	#>>> KSPACING=0.5(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kspac 0.5 Gamma
	cp NEWKPT KPOINTS

while ((1))
do

rm AFFPOSI
${ADAIS_DIR}/bin/ADAIS --affine -pure3d ten_str shear_str istr0 step_length step_num
#${ADAIS_DIR}/bin/ADAIS --affine -simp3d ten_str shear_str istr0 step_length step_num
#${ADAIS_DIR}/bin/ADAIS --affine -unia2d ten_str shear_str istr0 step_length step_num
#${ADAIS_DIR}/bin/ADAIS --affine -biax2d ten_str shear_str istr0 step_length step_num

if [ -s AFFPOSI ]; then
	cp AFFPOSI POSCAR
else
	break
fi

# To set up the iteration
for Niter in {1..6} # 6-maximum iteration number
do

	# To run VASP  
	if [ -s INCAR ] && [ -s POSCAR ] && [ -s KPOINTS ] && [ -s POTCAR ]; then
	        ${VASP_DIR}/vasp_3d_shear >> olog.vasp
		#${VASP_DIR}/vasp_3d_ten >> olog.vasp
		#${VASP_DIR}/vasp_2d_uniax >> olog.vasp
		#${VASP_DIR}/vasp_2d_biax >> olog.vasp
	else
	        echo "Necessary files: INCAR POSCAR KPOINTS or POTCAR is not ready!!"
	        continue
	fi

	# To check the convergence for termination
	
	fconv_indx=$(${ADAIS_DIR}/bin/ADAIS --fconv)
	if [ ${fconv_indx} -eq 1 ] || [ ${Niter} -gt 5 ]; then

		# To generate results
		if [ -s OUTCAR ]; then
			${ADAIS_DIR}/bin/ADAIS --output
		else
			echo "OUTCAR does not exist or is empty"
		fi
		break

	else
		cp CONTCAR POSCAR
	fi

# To end up the iteration	
done	
done

${ADAIS_DIR}/bin/ADAIS --bond bond_cut

done

#rm POSCAR KPOINTS* INCAR* POTCAR
#rm CHG* CONTCAR DOSCAR OSZICAR OUTCAR EIGENVAL PCDAT WAVECAR XDATCAR IBZKPT vasprun.xml

#>>> make clean
#${ADAIS_DIR}/bin/ADAIS --clean

#END
