#! /bin/bash

#
#  Purpose:
#
#
#  Record of vevisions:
#      Data         Programmer        Description of change
#      ====         ==========        =====================
#   2017/03/17      Shihao Zhang      Original code
#
#  Variables:
#
#    ADAIS_DIR : The path of the source code of ADAIS
#    VASP_DIR  : The path of the compiled VASP
#    POT_DIR   : The path of the POTCAR file
#
#
#

ADAIS_DIR=''
VASP_DIR=''
POT_DIR=''

for SYS_name in structure_file
do

#>>> create POTCAR file
	
	cat ${POT_DIR}/POT_xxx > ./POTCAR

#>>> create INCAR file using ADAIS and the file incar_rlx and incar_stc are created

	#>>> the pressure in 0GPa (default value)
	${ADAIS_DIR}/bin/ADAIS --incar -rlx
	#${ADAIS_DIR}/bin/ADAIS --incar -stc

	#>>> and the pressure is 100GPa
	#${ADAIS_DIR}/bin/ADAIS --incar -rlx 100
	#${ADAIS_DIR}/bin/ADAIS --incar -stc 100
	cp incarx INCAR

#>>> redefine the lattice

	cp ./structure/${SYS_name}.vasp ./INPOS
	#${ADAIS_DIR}/ADAIS --ieee -3d
	#${ADAIS_DIR}/ADAIS --ieee -2d
	#cp IEEEPOS INPOS
	
	${ADAIS_DIR}/bin/ADAIS --newlat vect11 vect12 vect13 vect21 vect22 vect23 vect31 vect32 vect33

	#cp REDPOS INPOS
	#${ADAIS_DIR}/bin/ADAIS --super sup_1 sup_2 sup_3

	cp SUPPOS ALIPOS0

#>>> create KPOINTS file using ADAIS and the file NEWKPT are created

	cp SUPPOS INPOS
	#>>> kmesh=10x10x10 with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kmesh 10 10 10 Gamma

	#>>> KPPRA=1000(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	${ADAIS_DIR}/bin/ADAIS --kpt -kppra 1000 Gamma

	#>>> KSPACING=0.5(default value) with Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
	#${ADAIS_DIR}/bin/ADAIS --kpt -kspac 0.5 Gamma
	cp NEWKPT KPOINTS

while ((1))
do

	rm ALIPOSI
	${ADAIS_DIR}/bin/ADAIS --alias -dxy3d istartx iendx ispacingx istarty iendy ispacingy zvalue
	#${ADAIS_DIR}/bin/ADAIS --alias -dxy2d istartx iendx ispacingx istarty iendy ispacingy zvalue
	#${ADAIS_DIR}/bin/ADAIS --alias -dz istartz iendz ispacingz zvalue
	
	if [ -s ALIPOSI ]; then
		cp ALIPOSI POSCAR
	else
		break
	fi

	# To run VASP  
	if [ -s INCAR ] && [ -s POSCAR ] && [ -s KPOINTS ] && [ -s POTCAR ]; then
	        ${VASP_DIR}/vasp >> olog.vasp
	else
	        echo "Necessary files: INCAR POSCAR KPOINTS or POTCAR is not ready!!"
	        continue
	fi

	# To generate results
	if [ -s OUTCAR ]; then
		${ADAIS_DIR}/bin/ADAIS --output
	else
		echo "OUTCAR does not exist or is empty"
	fi

done
done

#rm POSCAR KPOINTS* INCAR* POTCAR
#rm CHG* CONTCAR DOSCAR OSZICAR OUTCAR EIGENVAL PCDAT WAVECAR XDATCAR IBZKPT vasprun.xml

#>>> make clean
#${ADAIS_DIR}/bin/ADAIS --clean

#END

