SUBROUTINE alishear2d(dx, dy,  &
                      zvalue,  &
                      alicount,&
                      loopnumxy)
!
!  Purpose:
!
!    To apply alias shearing deformation in the x-y plane to the current structure for calculating
!    the generalized stacking fault energy (GSFE) of 2D materials
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    alicount  : The alicount_th step for alias deformation
!    loopnumxy : The step number for xy axis, i.e., loopnumxy=loopnumx*loopnumy
!    dx(y)     : The displacement along x (y) axis
!    zvalue    : The alias deformation will be applied to the atoms, whose z coordinate > zvalue
!    alivect   : The vectors defining the unit cell of the system after alias shearing deformation
!    alipos    : Three coordinates for each atom after alias shearing deformation
!    alifix    : Three additional logical flags determining whether to allow changes of the coordinates or not
!
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name, outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

INTEGER :: alicount,loopnumxy

DOUBLE PRECISION :: dx, dy, zvalue
DOUBLE PRECISION :: alivect(3,3), alipos(ATOMMAX,3)

CHARACTER(len=1) :: alifix(ATOMMAX,3)

! To read the POSCAR file

inpos_name='ALIPOS0'

CALL readpos(inpos_name,      &
             pos_title,       &
             alat,            &
             privect,         &
             ele_symbol,      & 
             ntype,           &
             natom,           &
             natomi,          & 
             ndynamic,        &
             ncoord,          &
             pripos,          &
             prifix,          &
             atom_type)

! End of reading the POSCAR file

! To carte
CALL cartepos(alat,     &
              privect,  &
              natom,    &
              ncoord,   &
              pripos)

IF ( ABS(privect(1,3)).GT.ZERO_TOLERANCE .OR.  &
     ABS(privect(2,3)).GT.ZERO_TOLERANCE ) THEN

        OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
        WRITE(19,*)
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        WRITE(19,*) '|                                     ERROR                                   |'
        WRITE(19,*) '|                            -----------------------                          |'
        WRITE(19,*) '|    Lattice vectors a and b in x-y plane are required!                       |'
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        CLOSE(19)
        STOP

ENDIF

! To calculate the zvalue      
IF ( ABS(zvalue+1.0000) .LT. ZERO_TOLERANCE ) THEN
        CALL zvaluer(inpos_name,&
                     zvalue,    &
                     alat,      &
                     privect,   &
                     natom,     &
                     ncoord,    &
                     pripos)
ENDIF

! Shear deformation by changing the 3rd cell vector c:dx,dy 

DO i=1, natom
   IF ( pripos(i,3) .GT. zvalue ) THEN
           alipos(i,1)=pripos(i,1)+(dx*privect(1,1)+dy*privect(2,1))*alat
           alipos(i,2)=pripos(i,2)+(dx*privect(1,2)+dy*privect(2,2))*alat
           alipos(i,3)=pripos(i,3)
   ELSE
           alipos(i,1)=pripos(i,1)
           alipos(i,2)=pripos(i,2)
           alipos(i,3)=pripos(i,3)
   ENDIF
ENDDO

! To change the 3rd cell vector c: dx, dy

DO i=1,3
   DO j=1,3
      alivect(i,j)=privect(i,j)
   ENDDO
ENDDO
! alivect(3,1)=alivect(3,1)+(dx*privect(1,1)+dy*privect(2,1))
! alivect(3,2)=alivect(3,2)+(dx*privect(1,2)+dy*privect(2,2))

! To direct
CALL directpos(alat,     &
               alivect,  &
               natom,    &
               ncoord,   &
               alipos)

! Selective dynamic        
DO i=1,natom
   alifix(i,1)='F'
   alifix(i,2)='F'
   alifix(i,3)='T'
ENDDO

! To output the results

OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')

WRITE(19,*)
WRITE(19,'(A,I04.4,A1,I04.4)') '  ALIAS SHEARING DEFORMATION      ', alicount, '/', loopnumxy
WRITE(19,*) ' ----------------------------------------------------------------------------- '
WRITE(19,*) '| Before alias shearing deformation, the POS file:' 
WRITE(19,*) '| '
DO i=1,3
   WRITE(19,'(A3,3F20.12)') '| ', (privect(i,j), j=1,3)
ENDDO
WRITE(19,'(A3,10A5)') '| ',(ele_symbol(i), i=1,ntype)
WRITE(19,'(A3,10I4)') '| ',(natomi(i), i=1,ntype)
DO i=1, natom
   WRITE(19,'(A3,3F20.10)') '| ',(pripos(i,j), j=1,3)
ENDDO

WRITE(19,*) '| '
WRITE(19,*) '| -----------------------------------------'
WRITE(19,'(A,3F8.4)') ' | dx, dy and zvalue (in Ang):',  &
              dx*SQRT(privect(1,1)**2+privect(1,2)**2),  &
              dy*SQRT(privect(2,1)**2+privect(2,2)**2), zvalue
WRITE(19,*) '| -----------------------------------------'
WRITE(19,*) '| '

WRITE(19,*) '| After alias shearing deformation, the POS file:' 
WRITE(19,*) '| '
DO i=1,3
   WRITE(19,'(A3,3F20.12)') '| ',(alivect(i,j), j=1,3)
ENDDO
WRITE(19,'(A3,10A5)') '| ',(ele_symbol(i), i=1,ntype)
WRITE(19,'(A3,10I4)') '| ',(natomi(i), i=1,ntype)
DO i=1, natom
   WRITE(19,'(A3,3F20.10,3A3)') '| ',(alipos(i,j), j=1,3), (alifix(i,j), j=1,3)
ENDDO

CLOSE(19)

! To write the POSCAR file

ndynamic=01
outpos_name='ALIPOSI'

CALL writepos(outpos_name,     &
              pos_title,       &
              alat,            &
              alivect,         &
              ele_symbol,      & 
              ntype,           &
              natom,           &
              natomi,          & 
              ndynamic,        &
              ncoord,          &
              alipos,          &
              alifix)
            
! End of writing the POSCAR file

END SUBROUTINE alishear2d
