SUBROUTINE astruc2d(area,  &
                    alat,  &
                    privect)
!
!  Purpose:
!
!    To calculate the cross-sectional area of the structure from the structrue file for 2D material
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    area      : The area of a-b plane
!    recipvect : The reciprocal matrix of privect(3,3)
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3)

! The variables for main program

DOUBLE PRECISION :: area
DOUBLE PRECISION :: recipvect(3)

recipvect(1)=privect(1,2)*privect(2,3)-privect(2,2)*privect(1,3)
recipvect(2)=privect(1,3)*privect(2,1)-privect(2,3)*privect(1,1)
recipvect(3)=privect(1,1)*privect(2,2)-privect(2,1)*privect(1,2)

! Unit: A^2

area=alat**2*SQRT(recipvect(1)**2+  &
                  recipvect(2)**2+  &
                  recipvect(3)**2)

END SUBROUTINE astruc2d
