        SUBROUTINE brinv(A,N)

        !
        !  Purpose:
        !
        !    To solve the inverse of the matrix according the "Gauss-Jordan" method 
        !
        !  Record of vevisions:
        !      Data         Programmer        Description of change
        !      ====         ==========        =====================
        !   2017/03/17      Shihao Zhang      Original code
        !
        !  Variables:
        !
        !
        !        


        DIMENSION A(N,N),IS(N),JS(N)
        DOUBLE PRECISION A,T,D
        L=1
        DO 1000 K=1,N
          D=0.0
          DO 130 I=K,N
          DO 130 J=K,N
            IF (ABS(A(I,J)).GT.D) THEN
              D=ABS(A(I,J))
              IS(K)=I
              JS(K)=J
            END IF
130       CONTINUE
          IF (D+1.0.EQ.1.0) THEN
            L=0
            WRITE(*,200)
            RETURN
          END IF
200       FORMAT(1X,'ERR**NOT INV')
          DO 300 J=1,N
            T=A(K,J)
            A(K,J)=A(IS(K),J)
            A(IS(K),J)=T
300       CONTINUE
          DO 400 I=1,N
            T=A(I,K)
            A(I,K)=A(I,JS(K))
            A(I,JS(K))=T
400       CONTINUE
          A(K,K)=1/A(K,K)
          DO 500 J=1,N
            IF (J.NE.K) THEN
              A(K,J)=A(K,J)*A(K,K)
            END IF
500       CONTINUE
          DO 700 I=1,N
            IF (I.NE.K) THEN
              DO 600 J=1,N
                IF (J.NE.K) THEN
                  A(I,J)=A(I,J)-A(I,K)*A(K,J)
                END IF
600           CONTINUE
            END IF
700       CONTINUE
          DO 800 I=1,N
            IF (I.NE.K) THEN
              A(I,K)=-A(I,K)*A(K,K)
            END IF
800       CONTINUE
1000    CONTINUE
        DO 1300 K=N,1,-1
          DO 1100 J=1,N
            T=A(K,J)
            A(K,J)=A(JS(K),J)
            A(JS(K),J)=T
1100      CONTINUE
          DO 1200 I=1,N
            T=A(I,K)
            A(I,K)=A(I,IS(K))
            A(I,IS(K))=T
1200      CONTINUE
1300    CONTINUE
        RETURN
        END SUBROUTINE brinv
