!-----------------------------------------------------------------------
!
! At present, VASP does not allow to relax the cellshape selectively
! i.e. for instance only cell relaxation in x direction.
! To be more precisse, this behaviour can not be achived via the INCAR
! or POSCAR file.
! However, it is possible to set selected components of the stress tensor
! to zero.
! The most conveninent position to do this is the routines 
! CONSTR_CELL_RELAX  (constraint cell relaxation).
! FCELL contains the forces on the basis vectors.
! These forces are used to modify the basis vectors according
! to the following equations:
!
!      A_OLD(1:3,1:3)=A(1:3,1:3) ! F90 style 
!      DO J=1,3
!      DO I=1,3
!      DO K=1,3
!        A(I,J)=A(I,J) + FCELL(I,K)*A_OLD(K,J)*STEP_SIZE
!      ENDDO
!      ENDDO
!      ENDDO
! where A holds the basis vectors (in cartesian coordinates).
!
!-----------------------------------------------------------------------

      SUBROUTINE CONSTR_CELL_RELAX(FCELL)
      USE prec
      REAL(q) FCELL(3,3)

!     just one simple example
!     relaxation in x directions only
!      SAVE=FCELL(1,1)
!      FCELL=0   ! F90 style: set the whole array to zero
!      FCELL(1,1)=SAVE
!     relaxation in z direction only
!      SAVE=FCELL(3,3)
!      FCELL=0   ! F90 style: set the whole array to zero
!      FCELL(3,3)=SAVE

      SAVE11=FCELL(1,1)
      SAVE22=FCELL(2,2)
      SAVE33=FCELL(3,3)
      SAVE12=FCELL(1,2)
      SAVE13=FCELL(1,3)
      SAVE21=FCELL(2,1)
      SAVE23=FCELL(2,3)
      SAVE31=FCELL(3,1)
      SAVE32=FCELL(3,2)


!      FCELL=0   ! F90 style: set the whole array to zero
      FCELL(1,1)=0.0
      FCELL(2,2)=0.0
      FCELL(3,3)=0.0
      FCELL(1,2)=0.0
      FCELL(1,3)=0.0
      FCELL(2,1)=0.0
      FCELL(2,3)=0.0
      FCELL(3,1)=0.0
      FCELL(3,2)=0.0

      FCELL(1,1)=SAVE11
      FCELL(2,2)=SAVE22
      FCELL(3,3)=SAVE33
!      FCELL(1,2)=SAVE12
      FCELL(1,3)=SAVE13
!      FCELL(2,1)=SAVE21
      FCELL(2,3)=SAVE23
      FCELL(3,1)=SAVE31
      FCELL(3,2)=SAVE32

      RETURN
      END SUBROUTINE

