SUBROUTINE directpos(alat,     &
                     privect,  &
                     natom,    &
                     ncoord,   &
                     pripos)
!
!  Purpose:
!
!    To transform cartesian coordinates to fractional coordinates
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    transvect : The transition matrix for carte -> direct
!    dirpos    : Three coordinates for each atom with Direct mode
!
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=1) :: pricoord, select_dynamic
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

DOUBLE PRECISION :: transvect(3,3), dirpos(ATOMMAX,3)

! defect the transvect matrix

DO i=1,3
   DO j=1,3
      transvect(i,j)=privect(i,j)*alat
   ENDDO
ENDDO
IF ( ncoord .EQ. 1 ) THEN
        CALL brinv(transvect,3)
ENDIF

! IF ( ncoord.NE.0 .AND. ncoord.NE.1 ) THEN
!         OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE') 
!         WRITE(19,*) 'ERROR!! NOT DIRECT OR CARTESIAN!!!'
!         CLOSE(19)
!         STOP
! ENDIF

! transform the coordinate

IF ( ncoord .EQ. 1 ) THEN
        ncoord=0
        DO i=1,natom
           DO j=1,3
              dirpos(i,j)=0.0000
              DO k=1,3
                 dirpos(i,j)=dirpos(i,j)+pripos(i,k)*transvect(k,j)
              ENDDO
           ENDDO
        ENDDO

        DO i=1,natom
           DO j=1,3
              pripos(i,j)=dirpos(i,j)
           ENDDO
        ENDDO
ENDIF

END SUBROUTINE directpos
