SUBROUTINE forceconv
!
!  Purpose:
!
!    To judge whether the relaxation of the structure is convergent, i.e., the conjugate
!    Hellmann-Feynman stresses reaches negligible values
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    Pxx, Pyy, Pzz, Pxy, Pyz, Pzx: Six stress component of structure in OUTCAR file
!    Etot      : TOTEN in OUTCAR file
!    Ece       : Energy without entropy in OUTCAR file
!    Esep      : Energy(sigma->0) in OUTCAR file
!    Ef        : Fermi energy in OUTCAR file
!    Vol       : Volume of structure in OUTCAR file
!    pressure  : PSTRESS in INCAR file
!    
!    ten_str   : The weight for tensile strain, i.e., strain(1)=step_length*ten_str
!    shear_str : The weight for shearing strain, i.e., strain(2)=step_length*shear_str
!    istr0     : The initial strain value
!    step_length: The step length for affine deformation
!    step_num  : The step number for affine deformation
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for main program

INTEGER :: convindx

DOUBLE PRECISION :: Pxx, Pyy, Pzz, Pxy, Pyz, Pzx
DOUBLE PRECISION :: Etot, Ece, Esep, Ef, Vol, pressure
DOUBLE PRECISION :: ten_str, shear_str, istr0, step_length, step_num

CHARACTER(len=20) :: titstr1, titstr2
CHARACTER(len=20) :: tmpstr

CALL readoutcar(Pxx, Pyy, Pzz,   &
                Pxy, Pyz, Pzx,   &
                Etot, Ece, Esep, &
                Ef, Vol, pressure)

! To read the istrvalue values from LOOPCAR

OPEN(UNIT=87, FILE='LOOPCAR', STATUS='unknown')
READ(87,*) titstr1, titstr2

IF ( TRIM(titstr1) .EQ. 'AFFINE' ) THEN
        READ(87,*)
        READ(87,*) tmpstr, tmpstr, tmpstr, ten_str
        READ(87,*) tmpstr, tmpstr, tmpstr, shear_str
        READ(87,*) tmpstr, tmpstr, tmpstr, istr0
        READ(87,*) tmpstr, tmpstr, tmpstr, step_length
        READ(87,*) tmpstr, tmpstr, tmpstr, step_num
        CLOSE(87)
ELSE
        CLOSE(87)
        OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
        WRITE(19,*)
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        WRITE(19,*) '|                                     ERROR                                   |'
        WRITE(19,*) '|                            -----------------------                          |'
        WRITE(19,*) '|    "fconv" mode can be obtained only for affine deformation!                |'
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        CLOSE(19)
        STOP    
ENDIF

! For biaxial tensile deformation
IF ( TRIM(titstr2) .EQ. 'biax2d' ) THEN
        
        IF ( (Pzz-pressure)**2.LT.1.0000 .AND.  &
             Pxy**2.LT.1.0000 .AND.  &
             Pyz**2.LT.1.0000 .AND.  &
             Pzx**2.LT.1.0000 ) THEN
                convindx=1
        ELSE              
                convindx=0
        ENDIF

ELSE

        ! For tensile deformation of 3D material and uniaxial tensile deformation of 2D material
        IF ( ABS(ten_str).GE.ZERO_TOLERANCE .AND.  &
             ABS(shear_str).LT.ZERO_TOLERANCE ) THEN
        
                IF ( (Pxx-pressure)**2.LT.1.0000 .AND.  &
                     (Pzz-pressure)**2.LT.1.0000 .AND.  &
                     Pxy**2.LT.1.0000 .AND.  &
                     Pyz**2.LT.1.0000 .AND.  &
                     Pzx**2.LT.1.0000 ) THEN
                        convindx=1
                ELSE              
                        convindx=0
                ENDIF

        ! For shearing deformation
        ELSEIF ( ABS(ten_str).LT.ZERO_TOLERANCE .AND.  &
                 ABS(shear_str).GE.ZERO_TOLERANCE ) THEN
        
                IF ( (Pxx-pressure)**2.LT.1.0000 .AND.  &
                     (Pyy-pressure)**2.LT.1.0000 .AND.  &
                     (Pzz-pressure)**2.LT.1.0000 .AND.  &
                     Pyz**2.LT.1.0000 .AND.  &
                     Pzx**2.LT.1.0000 ) THEN
                        convindx=1
                ELSE
                        convindx=0
                ENDIF
        
        ! For tensile and shearing deformation
        ELSEIF ( ABS(ten_str).GE.ZERO_TOLERANCE .AND.  &
                 ABS(shear_str).GE.ZERO_TOLERANCE ) THEN
        
                IF ( (Pxx-pressure)**2.LT.1.0000 .AND.  &
                     (Pzz-pressure)**2.LT.1.0000 .AND.  &
                     Pyz**2.LT.1.0000 .AND.  &
                     Pzx**2.LT.1.0000 ) THEN
                        convindx=1
                ELSE
                        convindx=0
                ENDIF

        ENDIF

ENDIF

! convindx=1: convergent, and convindx=0: not convergent

WRITE(*,'(I3)') convindx

END SUBROUTINE forceconv
