SUBROUTINE help
!
!  Purpose:
!
!    To show the help message, including version information, license information and user-friendly
!    options of ADAIS
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!
!

USE constants
IMPLICIT NONE

! The variables for main program

! INTEGER :: 

WRITE(*,*)
WRITE(*,*) '                  AA     DDDDD        AA     II    SSSS                        '
WRITE(*,*) '                 A  A    DD   DD     A  A    II   SS   SS                      '
WRITE(*,*) '                A    A   DD    DD   A    A   II   SSS                          '
WRITE(*,*) '                AAAAAA   DD    DD   AAAAAA   II     SSS                        '
WRITE(*,*) '               AA    AA  DD   DD   AA    AA  II  SS   SS                       '
WRITE(*,*) '               AA    AA  DDDDD     AA    AA  II    SSSS   V1.0.0               '
WRITE(*,*) '                                                                               '
WRITE(*,*) ' LICENSE                                                                       '
WRITE(*,*) '|----------------------------------------------------------------------------- '
WRITE(*,*) '| Copyright[c] 2018-2019, S. H. Zhang and R. F. Zhang                          '
WRITE(*,*) '| ADAIS - an efficient open source command-line program for Automatic Deriva-  '
WRITE(*,*) '|         tion of Anisotropic Ideal Strength via high-throughput first         '
WRITE(*,*) '|         principles computations. It is designed by Dr. S.H. Zhang and Prof.  '
WRITE(*,*) '|         R.F. Zhang at Beihang University.                                    '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|  ----------------------------  Version 1.0.0  ----------------------------   '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '| This program is free software: you can redistribute it and/or modify it      '
WRITE(*,*) '| under the terms of the BSD 3-Clause License as published by the Free Software'
WRITE(*,*) '| Foundation, either version 3 of the License, or (at your option) any later   '
WRITE(*,*) '| version.                                                                     '
WRITE(*,*) '                                                                               '
WRITE(*,*) ' INSTALL                                                                       '
WRITE(*,*) '|----------------------------------------------------------------------------- '
WRITE(*,*) '| o Install of ADAIS                                                           '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! "cmake" is needed before installing ADAIS, and more information is in    '
WRITE(*,*) '|                                 https://cmake.org/                           '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! After expanding source code, and go into the source code directory:      '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|     % tar zxvf AELAS-x.x.x.tar.gz                                            '
WRITE(*,*) '|     % cd AELAS-x.x.x                                                         '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! The current directory is ADAIS_SOURCE_DIR                                '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|     % cd spglib-x.x.x                                                        '
WRITE(*,*) '|     % mkdir _build; cd _build                                                '
WRITE(*,*) '|     % cmake ..                                                               '
WRITE(*,*) '|     % make                                                                   '
WRITE(*,*) '|     % make install                                                           '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! The libraries are installed at ADAIS_SOURCE_DIR/spglib-1.9.9/lib and     '
WRITE(*,*) '|     the header file is installed at ADAIS_SOURCE_DIR/spglib-1.9.9/include    '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|     % cd ../../src                                                           '
WRITE(*,*) '|     % make -f makefile                                                       '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! Then the executable file ADAIS will be created in the folder of          '
WRITE(*,*) '|     ADAIS_SOURCE_DIR/bin                                                     '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '| o Install of slightly modified VASP                                          '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! To calculate the ideal strength via affine pure and simple deformation   '
WRITE(*,*) '|     for three-dimensional (3D) materials, both the atomic coordinates and    '
WRITE(*,*) '|     the atomic basis vectors are relaxed by modifying the five relevant      '
WRITE(*,*) '|     strain components while remaining the applied strain component unchanged.'
WRITE(*,*) '|     The relaxation will be terminated when the five conjugate Hellmann-      '
WRITE(*,*) '|     Feynman stresses reaches negligible values. While to calculate the ideal '
WRITE(*,*) '|     strength via affine uniaxial and biaxial tensile deformation for two-    '
WRITE(*,*) '|     dimensional (2D) materials, besides the applied strain component remains '
WRITE(*,*) '|     unchanged, the components related to z-axis (perpendicular to the atomic '
WRITE(*,*) '|     layers of 2D materials), i.e., e_zz, e_yz and e_zx, also remain          '
WRITE(*,*) '|     unrelaxed.                                                               '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! In order to implement such relaxation automatically, one need to         '
WRITE(*,*) '|     slightly modify VASP optimizer with cell constraints. In ADAIS, four     '
WRITE(*,*) '|     modified constr_cell_relax.F file are provided in ADAIS_SOURCE_DIR/src/  '
WRITE(*,*) '|     to meet different conditions: i.e., constr_cell_relax_3d_ten.F and       '
WRITE(*,*) '|     constr_cell_relax_3d_shear.F for the calculation of the tensile and      '
WRITE(*,*) '|     shearing ideal strengths for 3D materials via affine pure and simple     '
WRITE(*,*) '|     deformations, and constr_cell_relax_2d_uniax.F and                       '
WRITE(*,*) '|     constr_cell_relax_2d_biax.F for the calculation of the uniaxial and      '
WRITE(*,*) '|     biaxial tensile strengths for 2D materials via affine tensile            '
WRITE(*,*) '|     deformation, respectively.                                               '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|   ! Before compiling the modified VASP, the original VASP source             '
WRITE(*,*) '|     constr_cell_relax.F is needed to be replaced by the one                  '
WRITE(*,*) '|     constr_cell_relax_xxx_xxx.F, by renaming it to constr_cell_relax.F.      '
WRITE(*,*) '|     Then, please compile the VASP package and get the executable file vasp   '
WRITE(*,*) '|     or vasp_std. Finally, rename the executable file to vasp_xxx_xxx. Note   '
WRITE(*,*) '|     that the original VASP is also necessary for the calculation of other    '
WRITE(*,*) '|     propertied via alias deformation obtained in ADAIS code.                 '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '                                                                               '
WRITE(*,*) ' MODES                                                                         '
WRITE(*,*) '|----------------------------------------------------------------------------- '
WRITE(*,*) '| o A short overview of all input modes currently supported in ADIAS code,     '
WRITE(*,*) '|   together with a short description. For more information of these modes,    '
WRITE(*,*) '|   the user may refer to the manual of ADAIS code in the folder of            '
WRITE(*,*) '|   ADAIS_SOURCE_DIR/docs                                                      '
WRITE(*,*) '|                                                                              '
WRITE(*,*) '|    1/ affine - Applying affine deformation to the structure of 3D and 2D     '
WRITE(*,*) '|       materials                                                              '
WRITE(*,*) '|    2/ alias - Applying alias deformation to the structure of 3D and 2D       '
WRITE(*,*) '|       materials                                                              '
WRITE(*,*) '|    3/ proj - Projecting the specific orientation of the given crystal to be  '
WRITE(*,*) '|       parallel to three axes x, y and z                                      '
WRITE(*,*) '|    4/ newlat - Redefining new right-handed lattice vectors of the current    '
WRITE(*,*) '|       crystal                                                                '
WRITE(*,*) '|    5/ ieee - Transforming the structure to IEEE-format for 3D and 2D         '
WRITE(*,*) '|       materials                                                              '
WRITE(*,*) '|    6/ super - Building the supercell of the current crystal                  '
WRITE(*,*) '|    7/ output - Reading the energy and stress from the VASP output file       '
WRITE(*,*) '|       OUTCAR after first-principles calculation                              '
WRITE(*,*) '|    8/ fconv - Judging whether the relaxation of the structure is convergent  '
WRITE(*,*) '|    9/ symm - Determining automatically the symmetry of structure and the     '
WRITE(*,*) '|       possible slip system according to space group                          '
WRITE(*,*) '|   10/ bond - Analyzing the variation of bond length as a function of the     '
WRITE(*,*) '|       strain value for affine deformation                                    '
WRITE(*,*) '|   11/ incar - Creating INCAR file with a given pressure value                '
WRITE(*,*) '|   12/ kpt - Creating the KPOINTS file used in VASP                           '
WRITE(*,*) '|   13/ help - Showing the help message, including version information,        '
WRITE(*,*) '|       license information and user-friendly options of ADAIS                 '
WRITE(*,*) '|   14/ clean - Cleaning all the input and output file of ADAIS code           '
WRITE(*,*) '|                                                                              '

END SUBROUTINE help
