SUBROUTINE incarx(rlx_stc,pressure)
!
!  Purpose:
!
!    To create INCAR file with PSTRESS=pressure
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    pressure  : The pressure value for vreacing incar file, i.e. PSTRESS
!    rlx_stc   : 'rlx' with ionic relaxation (ISIF=3); 'stc' without ionic relaxation
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for main program

DOUBLE PRECISION :: pressure

CHARACTER(len=3) :: rlx_stc

IF ( rlx_stc .EQ. 'rlx' ) THEN

        OPEN(UNIT=11, FILE='incarx', STATUS='unknown')

        WRITE(11,'(A12)') 'SYSTEM=ADAIS'
        WRITE(11,'(A8)')  'ISTART=0'
        WRITE(11,'(A8)')  'ICHARG=2'
        WRITE(11,'(A13)') 'PREC=Accurate'
        IF ( pressure .GT. 0 ) THEN
                WRITE(11,'(A8,F8.2)') 'PSTRESS=', pressure
        ENDIF

        WRITE(11,*)
        WRITE(11,'(A23)') '# Electronic relaxation'
        WRITE(11,'(A9)')  'ENCUT=520'
        WRITE(11,'(A10)') 'EDIFF=1E-6'
        WRITE(11,*)
        WRITE(11,'(A8)')  'ISMEAR=0'
        WRITE(11,'(A10)') 'SIGMA=0.01'
        
        ! IF ( natom .GE. 18) THEN
        !         WRITE(11,'(A10)') 'LREAL=Auto'
        ! ELSE
        !         WRITE(11,'(A13)') 'LREAL=.FALSE.'
        ! ENDIF
        
        WRITE(11,'(A8)')  'NELMIN=5'
        WRITE(11,*)

        WRITE(11,'(A18)') '# Ionic relaxation'
        WRITE(11,'(A6)')  'NSW=50'
        WRITE(11,'(A12)') 'EDIFFG=-1E-3'
        WRITE(11,'(A6)')  'ISIF=3'  
        WRITE(11,*)
        WRITE(11,'(A8)')  'IBRION=2' 
        WRITE(11,'(A9)')  'POTIM=0.5'
        WRITE(11,'(A7)')  '#ISYM=0'
        WRITE(11,'(A13)') '#SYMPREC=1E-4'
        
        WRITE(11,*)
        WRITE(11,'(A13)') '# Write flags'
        WRITE(11,'(A13)') 'LWAVE=.FALSE.'
        WRITE(11,'(A14)') 'LCHARG=.FALSE.'

        CLOSE(11)

ELSEIF ( rlx_stc .EQ. 'atm' ) THEN

        OPEN(UNIT=11, FILE='incarx', STATUS='unknown')

        WRITE(11,'(A12)') 'SYSTEM=ADAIS'
        WRITE(11,'(A8)')  'ISTART=0'
        WRITE(11,'(A8)')  'ICHARG=2'
        WRITE(11,'(A13)') 'PREC=Accurate'
        IF ( pressure .GT. 0 ) THEN
                WRITE(11,'(A8,F8.2)') 'PSTRESS=', pressure
        ENDIF

        WRITE(11,*)
        WRITE(11,'(A23)') '# Electronic relaxation'
        WRITE(11,'(A9)')  'ENCUT=520'
        WRITE(11,'(A10)') 'EDIFF=1E-6'
        WRITE(11,*)
        WRITE(11,'(A8)')  'ISMEAR=0'
        WRITE(11,'(A10)') 'SIGMA=0.01'
        
        ! IF ( natom .GE. 18) THEN
        !         WRITE(11,'(A10)') 'LREAL=Auto'
        ! ELSE
        !         WRITE(11,'(A13)') 'LREAL=.FALSE.'
        ! ENDIF
        
        WRITE(11,'(A8)')  'NELMIN=5'
        WRITE(11,*)

        WRITE(11,'(A18)') '# Ionic relaxation'
        WRITE(11,'(A6)')  'NSW=50'
        WRITE(11,'(A12)') 'EDIFFG=-1E-3'
        WRITE(11,'(A6)')  'ISIF=2'  
        WRITE(11,*)
        WRITE(11,'(A8)')  'IBRION=2' 
        WRITE(11,'(A9)')  'POTIM=0.5'
        WRITE(11,'(A7)')  '#ISYM=0'
        WRITE(11,'(A13)') '#SYMPREC=1E-4'
        
        WRITE(11,*)
        WRITE(11,'(A13)') '# Write flags'
        WRITE(11,'(A13)') 'LWAVE=.FALSE.'
        WRITE(11,'(A14)') 'LCHARG=.FALSE.'

        CLOSE(11)

ELSEIF ( rlx_stc .EQ. 'stc' ) THEN

        OPEN(UNIT=21, FILE='incarx', STATUS='unknown')

        WRITE(21,'(A12)') 'SYSTEM=ADAIS'
        WRITE(21,'(A8)')  'ISTART=0'
        WRITE(21,'(A8)')  'ICHARG=2'
        WRITE(21,'(A13)') 'PREC=Accurate'
        IF ( pressure .GT. 0 ) THEN
                WRITE(21,'(A8,F8.2)') 'PSTRESS=', pressure
        ENDIF

        WRITE(21,*)
        WRITE(21,'(A23)') '# Electronic relaxation'
        WRITE(21,'(A9)')  'ENCUT=520'
        WRITE(21,'(A10)') 'EDIFF=1E-6'
        WRITE(21,*)
        WRITE(21,'(A8)')  'ISMEAR=0'
        WRITE(21,'(A10)') 'SIGMA=0.01'

        ! IF ( natom .GE. 18) THEN
        !         WRITE(21,'(A10)') 'LREAL=Auto'
        ! ELSE
        !         WRITE(21,'(A13)') 'LREAL=.FALSE.'
        ! ENDIF

        WRITE(21,'(A8)')  'NELMIN=5'

        WRITE(21,*)
        WRITE(21,'(A13)') '# Write flags'
        WRITE(21,'(A13)') 'LWAVE=.FALSE.'
        WRITE(21,'(A14)') 'LCHARG=.FALSE.'

        CLOSE(21)

ENDIF

END SUBROUTINE incarx
