SUBROUTINE kpt(kmesh,  &
               kscheme)
!
!  Purpose:
!
!    To create the NEWKPT file in KPOINTS format according to the user's input k_1,
!    K_2 and k_3
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    kmesh     : Three k_i values for creating kpt file via kmesh method
!    kscheme   : The type mesh to use: Gamma shift or Monkorst-Pack. ("mp" or "g")
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for main program

INTEGER :: i
INTEGER :: kmesh(3)

CHARACTER(len=1) :: kscheme

! Writing the kemsh(i)

OPEN(UNIT = 19,POSITION = 'Append',FILE = 'OUTFILE') 

WRITE(19,*)
WRITE(19,*) ' KMESH METHOD'
WRITE(19,*) ' ----------------------------------------------------------------------------- '
WRITE(19,*) '| '
WRITE(19,*) '| Automatic mesh'
WRITE(19,*) '|   0'
IF(kscheme.EQ.'m' .OR. kscheme.EQ.'M') THEN
        WRITE(19,*)  '| Monkhorst-pack'
ELSE
        write(19,*)  '| Gamma-centered'
ENDIF
WRITE(19,'(A3,3I3)') '| ', (kmesh(i), i=1,3)
WRITE(19,*) '|   0  0  0'

CLOSE(19)

! To write the NEWKPT file

OPEN(UNIT = 30, FILE = 'NEWKPT', STATUS = 'unknown')

WRITE(30,'(A14)') 'Automatic mesh'
WRITE(30,'(A3)')  '  0'
IF(kscheme.EQ.'m' .OR. kscheme.EQ.'M') THEN
        WRITE(30,'(A14)')  'Monkhorst-pack'
ELSE
        WRITE(30,'(A14)')  'Gamma-centered'
ENDIF
WRITE(30,'(3I3)') (kmesh(i), i=1,3)
WRITE(30,'(A9)') '  0  0  0'

CLOSE(30)

END SUBROUTINE kpt
