SUBROUTINE kptv(kspac,  &
                kscheme)
!
!  Purpose:
!
!    To create the KPOINTS file according the "kspacing". kspacing is the 
!    smalling allowed spacing between k-points in unit A^-1. The number 
!    of k-points increases when the spacing in decreased.
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    kspac     : The input kspacing value
!    kshame    : the type mesh to use: Gamma-centered or Monkorst-Pack. ("m" "M" or "g" "G") 
!    imesh     : The calculated k_i values based on the kspac value
!    recipvect : The reciprocal lattice vectors of privect in VASP
!    reciplgth : The length of recipvect, i.e., reciplgth(i)=SQRT(recipvect(i,1)**2+(recipvect(i,2)**2+(recipvect(i,3)**2)
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name, outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

INTEGER :: imesh(3)

DOUBLE PRECISION :: kspac
DOUBLE PRECISION :: reciplgth(3), recipvect(3,3), tmpvect(3,3)

CHARACTER(len=1) :: kscheme

! To read the POSCAR file

inpos_name='INPOS'

CALL readpos(inpos_name,      &
             pos_title,       &
             alat,            &
             privect,         &
             ele_symbol,      & 
             ntype,           &
             natom,           &
             natomi,          & 
             ndynamic,        &
             ncoord,          &
             pripos,          &
             prifix,          &
             atom_type)

! End of reading the POSCAR file

OPEN(UNIT = 19, POSITION = 'Append', FILE='OUTFILE') 

WRITE(19,*)
WRITE(19,*) ' KSPAC METHOD'
WRITE(19,*) ' ----------------------------------------------------------------------------- '

WRITE(19,*) '| After reading, the three lattice vectors:'
WRITE(19,*) '| '
DO i=1,3
   WRITE(19,'(A3,3F20.15)') '| ', (privect(i,j),j=1,3)
ENDDO
WRITE(19,'(A3,10A5)') '| ', (ele_symbol(i), i=1,ntype)
WRITE(19,'(A3,10I4)') '| ', (natomi(i), i=1,ntype)

WRITE(19,*) '| -----------------------------------------'
WRITE(19,'(A,F8.4)') ' | Smalling allowed spacing between k-points is ', kspac
WRITE(19,*) '| -----------------------------------------'

CLOSE(19)

! define the reciprocal lattice vectors of privect in VASP

DO i=1,3
   DO j=1,3
      tmpvect(i,j)=privect(i,j)
   ENDDO
ENDDO

CALL brinv(tmpvect,3)

DO i=1,3
   DO j=1,3
      ! Note that a transposition is applied to tmpvect
      recipvect(i,j)=2*PI*tmpvect(j,i)
   ENDDO
ENDDO

! define the reciplgth(i) and imesh(i)

DO i=1, 3
   reciplgth(i)=0.0000
   DO j=1, 3
      reciplgth(i)=reciplgth(i)+recipvect(i,j)**2
   ENDDO
   reciplgth(i)=SQRT(reciplgth(i))
ENDDO

DO i=1, 3
   imesh(i)=CEILING(reciplgth(i)/kspac)

   IF ( imesh(i) .LT. 1 ) THEN
           imesh(i)=1
   ENDIF
ENDDO

! Floor and Ceiling

! IF ( kscheme.NE.'m' .AND. kscheme.NE.'g' .AND.  &
!      kscheme.NE.'M' .AND. kscheme.NE.'G' ) THEN
! 
!         OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
!         WRITE(19,*) 'Error!!! NOT "M" OR "G" FOR KSCHEME'
!         CLOSE(19)
!         STOP
! ENDIF

IF ( kscheme.EQ.'m' .OR. kscheme.EQ.'M' ) THEN
        DO i=1, 3
           IF ( MOD(imesh(i),2) .EQ. 1 ) THEN
                      imesh(i)=imesh(i)+1
           ENDIF
        ENDDO
ENDIF

! To avoid imesh(i)==0

DO i=1,3
   IF( imesh(i) .EQ. 0 ) THEN
           imesh(i)=imesh(i)+1
   ENDIF
ENDDO

! Writing the kemsh(i)

OPEN(UNIT = 19,POSITION = 'Append',FILE = 'OUTFILE') 

WRITE(19,*) '| '
WRITE(19,*) '| Automatic mesh'
WRITE(19,*) '|   0'
IF(kscheme.EQ.'m' .OR. kscheme.EQ.'M') THEN
        WRITE(19,*)  '| Monkhorst-pack'
ELSE
        write(19,*)  '| Gamma-centered'
ENDIF
WRITE(19,'(A3,3I3)') '| ', (imesh(i), i=1,3)
WRITE(19,*) '|   0  0  0'

CLOSE(19)

! To write the NEWKPT file

OPEN(UNIT=30, FILE='NEWKPT', STATUS = 'unknown')

WRITE(30,'(A14)') 'Automatic mesh'
WRITE(30,'(A3)') '  0'
IF( kscheme.EQ.'m' .OR. kscheme.EQ.'M' ) THEN
        WRITE(30,'(A14)') 'Monkhorst-pack'
ELSE
        WRITE(30,'(A14)') 'Gamma-centered'
ENDIF
WRITE(30,'(3I3)') (imesh(i), i=1,3)
WRITE(30,'(A9)') '  0  0  0'

CLOSE(30)

END SUBROUTINE kptv
