SUBROUTINE nnumber(row_num,         &
                   file_channel,    &
                   ntype)
!
!  Purpose:
!
!    To get the number of element types in the structure file with format "vasp"
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    row_num   : row number to determine the number of data
!    file_chanmel: I/O unit code of the file
!    ntype     : determined number of data
!

IMPLICIT NONE

! The variables for main program

INTEGER row_num, file_channel, ntype

INTEGER :: i, j, k
INTEGER :: ntype_z, char_temp_len
INTEGER :: char_index(200)
CHARACTER(len=100) :: char_temp, char_temp1

REWIND( file_channel )

DO i=1, (row_num-1)
   READ(file_channel,*)
ENDDO

READ(file_channel,'(A100)') char_temp

char_temp_len=LEN_TRIM(char_temp)
        
char_temp1(2:char_temp_len+2)=char_temp(1:char_temp_len+1)
char_temp1(1:1)=' ' 
        
DO i=1, char_temp_len+2
   IF( char_temp1(i:i) .EQ. ' ' ) THEN
           char_index(i)=-1
   ELSE
           char_index(i)=1
   ENDIF
ENDDO 
        
ntype_z=0
DO i=1, char_temp_len+2    
   IF( char_index(i)*char_index(i+1) .EQ. -1 ) THEN
           ntype_z=ntype_z+1
   ENDIF
ENDDO

ntype=ntype_z/2
        
RETURN

END SUBROUTINE nnumber

