SUBROUTINE random(randr)
!
!  Purpose:
!
!    To create a matrix of random number (0~1) with size of rsize1*rsize2
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    randr     : The random matrix created via random function
!    seed      : The seed created based on the clock of system
!
!

USE constants
IMPLICIT NONE


! The variables for main program

INTEGER :: i
INTEGER :: rsize1, rsize2
INTEGER :: seed_size, clock
INTEGER, DIMENSION(:), ALLOCATABLE :: seed

DOUBLE PRECISION :: randr(ATOMMAX,3)

!

CALL RANDOM_SEED(SIZE=seed_size)
ALLOCATE(seed(seed_size))
CALL SYSTEM_CLOCK(COUNT=clock)
seed=clock+37*(/(i-1,i=1,seed_size)/)
CALL RANDOM_SEED(PUT=seed)
DEALLOCATE(seed)

CALL RANDOM_NUMBER(randr)

END SUBROUTINE random
