SUBROUTINE readoutcar(Pxx, Pyy, Pzz,   &
                      Pxy, Pyz, Pzx,   &
                      Etot, Ece, Esep, &
                      Ef, Vol, pressure)
!
!  Purpose:
!
!    To read energy and stress of the calculated structure from the VASP output file OUTCAR
!    after first-principles calculation
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    rownum    : The line number of OUTCAR file
!
!    Pxx, Pyy, Pzz, Pxy, Pyz, Pzx: Six stress component of structure in OUTCAR file
!    Etot      : TOTEN in OUTCAR file
!    Ece       : Energy without entropy in OUTCAR file
!    Esep      : Energy(sigma->0) in OUTCAR file
!    Ef        : Fermi energy in OUTCAR file
!    Vol       : Volume of structure in OUTCAR file
!    pressure  : PSTRESS in INCAR file
!

USE constants
IMPLICIT NONE

! The variables for main program

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ios, rownum
INTEGER :: Pxyz_index, Vol_index, Etot_index, Ece_index, Ef_index, press_index

DOUBLE PRECISION :: Pxx, Pyy, Pzz, Pxy, Pyz, Pzx
DOUBLE PRECISION :: Vol, Etot, Ece, Esep, Ef, pressure

CHARACTER(len=30) :: tmpstr
CHARACTER(len=6) :: filename

! Define the index

Pxyz_index=0
Vol_index=0
Etot_index=0
Ece_index=0
Ef_index=0
press_index=0

! Start to read the OUTCAR

filename='OUTCAR'
OPEN(UNIT=17, FILE=TRIM(filename), STATUS='unknown' )

rownum=0
DO
   READ(UNIT=17, FMT="(A)", IOSTAT=ios) tmpstr
   IF ( ios .EQ. -1 ) THEN
           EXIT
   ENDIF
   rownum=rownum+1
ENDDO

DO i=1,2
   BACKSPACE(17)
ENDDO

DO
   READ(17,'(A30)') tmpstr

   ! Pxx, Pyy, Pzz, Pxy, Pyz, Pzx
   IF ( Pxyz_index.EQ.0 .AND. tmpstr(3:7).EQ.'in kB' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, tmpstr, Pxx, Pyy, Pzz, Pxy, Pyz, Pzx
           Pxyz_index=1
           CYCLE
   ! volume of cell
   ELSEIF ( Vol_index.EQ.0 .AND. tmpstr(3:16).EQ.'volume of cell' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, tmpstr, tmpstr, tmpstr, Vol
           Vol_index=1
           CYCLE
   ! TOTEN           
   ELSEIF ( Etot_index.EQ.0 .AND. tmpstr(18:22).EQ.'TOTEN' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, tmpstr, tmpstr, tmpstr, Etot
           Etot_index=1
           CYCLE
   ! energy without entropy
   ELSEIF ( Ece_index.EQ.0 .AND. tmpstr(3:25).EQ.'energy  without entropy' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, tmpstr, tmpstr, Ece, tmpstr, tmpstr, Esep
           Ece_index=1
           CYCLE
   ! E-fermi
   ELSEIF ( Ef_index.EQ.0 .AND. tmpstr(2:8).EQ.'E-fermi' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, tmpstr, Ef
           Ef_index=1
           CYCLE
   ! PSTRESS
   ELSEIF ( press_index.EQ.0 .AND. tmpstr(4:10).EQ.'PSTRESS' ) THEN
           BACKSPACE(17)
           READ(17,*) tmpstr, pressure
           press_index=1
           CYCLE
   ELSE
           DO i=1,2
              BACKSPACE(17)
           ENDDO
   ENDIF

   rownum=rownum-1
   IF ( rownum .EQ. 0 ) THEN
           EXIT
   ENDIF
ENDDO

CLOSE(17)

END SUBROUTINE readoutcar
