SUBROUTINE readpos(inpos_name,      &
                   pos_title,       &
                   alat,            &
                   privect,         &
                   ele_symbol,      & 
                   ntype,           &
                   natom,           &
                   natomi,          & 
                   ndynamic,        &
                   ncoord,          &
                   pripos,          &
                   prifix,          &
                   atom_type)
!
!  Purpose:
!
!    To read the undeformed cell vector and atomic coordinates from the structure file 
!    with format "VASP"
!  
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    inpos_mane: Name of input file
!    outpos_name: Name of output file
!
!    pos_title : 'name' of the system
!    alat      : A universal scaling factor, which is used to scale all lattice vectors and all atomaic coordinates
!    privect   : The vectors defining the unit cell of the system
!    ele_symbol: 
!    ntype     : Number of atomic type
!    natom     : Total number of atoms
!    natomi    : Number of atoms per atomic species
!    ndynamic  : Ndynamic=1: Selective Dynamics switched on; ndynamic=0: Selective Dynamics switched off
!    ncoord    : Ncoord=1: Cartesian mode; ncoord=0: Direct mode
!    pripos    : Three coordinates for each atom
!    prifix    : Three additional logical flags determining whether to allow changes of the coordinates or not
!    atom_type : Array for atomic type using in SPGLIB
!
!    pricoord  : 'C' or 'c': Cartesian mode; 'D' or 'd': Direct mode
!    select_dynamic: 'S' or 's': Selective Dynamics switched on
!

USE constants
IMPLICIT NONE

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=1) :: pricoord, select_dynamic
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)
CHARACTER(len=100) :: str_tmp

LOGICAL :: filefound

! To determine whether the file exists        

str_tmp=TRIM(inpos_name)//' does not exit as reading POS file!'
DO i=(LEN_TRIM(str_tmp)+1),100
   str_tmp(i:i)=' '
ENDDO

INQUIRE ( FILE=inpos_name, EXIST=filefound )
IF ( .NOT. filefound ) THEN
        OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
        WRITE(19,*)        
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        WRITE(19,*) '|                                     ERROR                                   |'
        WRITE(19,*) '|                            -----------------------                          |'
        WRITE(19,'(A15, A, A5)') '|    The file ', str_tmp(1:60), '    |'
        IF ( LEN_TRIM(str_tmp) .GT. 60 ) THEN
                WRITE(19,'(A6, A, A34)') '|    ', str_tmp(61:100), '    |'
        ENDIF
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        CLOSE(19)
        STOP         
ENDIF

! To determine the number of atom type

OPEN( 10 ,FILE=TRIM(inpos_name) )
CALL nnumber(7, 10, ntype)   ! To determine the number of data at the 7th row of file "10"
CLOSE(10)

! Begin to read the POSCAR file

OPEN( 10, FILE=TRIM(inpos_name) )
READ(10,'(A30)') pos_title
READ(10,*) alat
DO i=1,3
   READ(10,*) ( privect(i,j), j=1,3 )
ENDDO
READ(10,*) ( ele_symbol(i), i=1,ntype )
READ(10,*) ( natomi(i), i=1,ntype )

! To determine the total number of atoms
natom=0
DO i = 1, ntype
   natom=natom+natomi(i) 
ENDDO


READ(10,*) select_dynamic

! ndynamic=1: Selective Dynamics switched on
! ndynamic=0: Selective Dynamics switched off

IF ( select_dynamic .EQ. 's' .OR. select_dynamic .EQ. 'S' ) THEN
        ndynamic=1
        READ(10,*) pricoord
        DO i=1, natom
        READ(10,*) ( pripos(i,j), j=1,3 ), ( prifix(i,j), j=1,3 ) 
        ENDDO
ELSE
        ndynamic=0
        pricoord=select_dynamic
        DO i=1, natom
           READ(10,*) ( pripos(i,j), j=1,3 )
           DO j=1, 3
              prifix(i,j)='T'
           ENDDO
        ENDDO
ENDIF

CLOSE(10)

! ncoord=1: Cartesian mode
! ncoord=0: Direct mode

str_tmp=inpos_name

str_tmp=TRIM(str_tmp)//'!'
DO i=(LEN_TRIM(str_tmp)+1),30
   str_tmp(i:i)=' '
ENDDO

IF ( pricoord .EQ. 'c' .OR. pricoord .EQ. 'C' ) THEN
        ncoord=1
ELSE IF ( pricoord .EQ. 'd' .OR. pricoord .EQ. 'D' ) THEN
        ncoord=0
ELSE
        OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
        WRITE(19,*)        
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        WRITE(19,*) '|                                     ERROR                                   |'
        WRITE(19,*) '|                            -----------------------                          |'
        WRITE(19,*) '|    NOT DIRECT OR CARTE as reading the POS file: ', str_tmp(1:28), '|'
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        CLOSE(19)
        STOP        
ENDIF

! To define the atom_type

atom_count(1)=0
DO i=1, ntype
   atom_count(i+1)=0
   DO j=1, i
      atom_count(i+1)=atom_count(i+1)+natomi(j)
   ENDDO
ENDDO

DO i=1, ntype
   DO j=atom_count(i)+1, atom_count(i+1)
      atom_type(j)=i           
   ENDDO
ENDDO

! End of defining the atom_type 

END SUBROUTINE readpos
