SUBROUTINE simpleshear(strain,     &
                       disturbing, &
                       distmat,    &
                       affcount,   &
                       step_num)
!
!  Purpose:
!
!    To apply affine simple deformation to the current structure of 3D materials
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    affcount  : The affcount_th step for affine deformation
!    step_num  : The step number for affine deformation
!    disturbing: Whether apply disturbance as apply affine stran (disturbing=1) or NOT (disturbing=0)
!    strain    : The values of tensile and shearing strain
!    simvect   : The vectors defining the unit cell of the system after applying affine simple deformation
!    strmat    : The strain matrix
!    simpos    : Three coordinates for each atom after applying disturbing
!    distmat   : Four input arguments for applying disturbance, i.e., distance, dxx, dyy and dzz
!    randr     : The random matrix created via random function
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name, outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

INTEGER :: affcount, step_num
INTEGER :: disturbing
DOUBLE PRECISION :: strain(2)
DOUBLE PRECISION :: simvect(3,3), strmat(3,3), simpos(ATOMMAX,3)
DOUBLE PRECISION :: distmat(4), randr(ATOMMAX,3)

! To read the POSCAR file

inpos_name='AFFPOS0'

CALL readpos(inpos_name,      &
             pos_title,       &
             alat,            &
             privect,         &
             ele_symbol,      & 
             ntype,           &
             natom,           &
             natomi,          & 
             ndynamic,        &
             ncoord,          &
             pripos,          &
             prifix,          &
             atom_type)

! End of reading the POSCAR file

! To direct
CALL directpos(alat,     &
               privect,  &
               natom,    &
               ncoord,   &
               pripos)

! Define the strain matrics 
! strain(1) for tensile stain and strain(2) for shearing strain

strmat(1,1)=1.0000
strmat(2,2)=strain(1)+1.0000
strmat(3,3)=1.0000
strmat(1,2)=strain(2)
strmat(2,1)=0.0000
strmat(1,3)=0.0000
strmat(3,1)=0.0000
strmat(2,3)=0.0000
strmat(3,2)=0.0000

! Transform the cell vector to new vector under strain
!        simvect(i,j)=privect(i,j)(I+strmat(i,j))

DO i=1,3
   DO j=1,3
      simvect(i,j)=0.0
      DO k=1,3
         simvect(i,j)=simvect(i,j)+privect(i,k)*strmat(k,j)
      ENDDO
   ENDDO 
ENDDO

! To output the results

OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')

WRITE(19,*)
WRITE(19,'(A,I03.3,A1,I03.3)') '  AFFINE SIMPLE DEFORMATION      ', affcount, '/', step_num
WRITE(19,*) ' ----------------------------------------------------------------------------- '
WRITE(19,*) '| Before affine simple deformation, the three lattice vectors:' 
WRITE(19,*) '| '
DO i=1,3
   WRITE(19,'(A3,3F20.12)') '| ', (privect(i,j), j=1,3)
ENDDO

WRITE(19,*) '| '
WRITE(19,*) '| -----------------------------------------'
WRITE(19,'(A,2F8.4)') ' | Tensile and shearing strain:', (strain(j), j=1,2)
WRITE(19,*) '| -----------------------------------------'
WRITE(19,*) '| Strain matrix is as follows:'
DO i=1,3
   WRITE(19,"(A11,3F8.4)") '|         ',(strmat(i,j),j=1,3)
ENDDO
WRITE(19,*) '| -----------------------------------------'
WRITE(19,*) '| '

WRITE(19,*) '| After affine simple deformation, the three lattice vectors:' 
WRITE(19,*) '| '
DO i=1,3
   WRITE(19,'(A3,3F20.12)') '| ',(simvect(i,j), j=1,3)
ENDDO

CLOSE(19)

! To carte
CALL cartepos(alat,     &
              simvect,  &
              natom,    &
              ncoord,   &
              pripos)

IF ( disturbing .EQ. 1 ) THEN
        CALL random(randr)
        DO i=1,natom
           DO j=1,3
              simpos(i,j)=pripos(i,j)+distmat(1)*distmat(1+j)*randr(i,j)
           ENDDO
        ENDDO
ELSEIF ( disturbing .EQ. 0 ) THEN
        DO i=1,natom
           DO j=1,3
              simpos(i,j)=pripos(i,j)
           ENDDO
        ENDDO
ENDIF

! To direct
CALL directpos(alat,     &
               simvect,  &
               natom,    &
               ncoord,   &
               simpos)

! To write the POSCAR file

outpos_name='AFFPOSI'

CALL writepos(outpos_name,     &
              pos_title,       &
              alat,            &
              simvect,         &
              ele_symbol,      & 
              ntype,           &
              natom,           &
              natomi,          & 
              ndynamic,        &
              ncoord,          &
              simpos,          &
              prifix,          &
              atom_type) 
            
! End of writing the POSCAR file

END SUBROUTINE simpleshear
