SUBROUTINE supercell(inpos_name, sup_range)
!
!  Purpose:
!
!    To build the supercell of the current crystal for 3D and 2D materials. A supercell has lattice
!    vectors which are integral multiples of their equivalents in the original lattice
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    sup_range : The range of supercell
!    sup_range_tot: sup_range(1)*sup_range(2)*sup_range(3)
!    sup_natom : Total number of atoms for supercell
!    sup_natomi: Number of atoms per atomic species for supercell
!    sup_atom_type: Array for atomic type using in SPGLIB for supercell
!    supvect   : The vectors defining the unit cell of the system for supercell
!    suppos    : Three coordinates for each atom for supercell
!    supfix    : Three additional logical flags determining whether to allow changes of the coordinates or not for supercell
!    
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name, outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

INTEGER :: countnum, sup_natom
INTEGER :: sup_range_tot, sup_range(3)
INTEGER :: sup_natomi(TYPEMAX), sup_atom_type(ATOMMAX)

DOUBLE PRECISION :: supvect(3,3), suppos(ATOMMAX,3)

CHARACTER(len=1) :: supfix(ATOMMAX,3)              

! To read the POSCAR file

CALL readpos(inpos_name,      &
             pos_title,       &
             alat,            &
             privect,         &
             ele_symbol,      & 
             ntype,           &
             natom,           &
             natomi,          & 
             ndynamic,        &
             ncoord,          &
             pripos,          &
             prifix,          &
             atom_type)

! End of reading the POSCAR file

! To direct
CALL directpos(alat,     &
               privect,  &
               natom,    &
               ncoord,   &
               pripos)

! To redefine the privect
DO i=1, 3
   DO j=1, 3
      supvect(i,j)=privect(i,j)*sup_range(i)
   ENDDO
ENDDO

! To 

sup_range_tot=1
DO i=1, 3
   sup_range_tot=sup_range_tot*sup_range(i)
ENDDO

sup_natom=natom*sup_range_tot
DO i=1, ntype
   sup_natomi(i)=natomi(i)*sup_range_tot
ENDDO
      
! To

DO ii=1, natom
   DO i=1, sup_range(1)
      DO j=1, sup_range(2)
         DO k=1, sup_range(3)
            countnum=(ii-1)*sup_range_tot+(i-1)*sup_range(2)*sup_range(3)+(j-1)*sup_range(3)+k
            suppos(countnum,1)=pripos(ii,1)+i-1
            suppos(countnum,2)=pripos(ii,2)+j-1
            suppos(countnum,3)=pripos(ii,3)+k-1
         ENDDO
      ENDDO
   ENDDO
ENDDO

DO i=1, sup_natom
   DO j=1, 3
      suppos(i,j)=suppos(i,j)/sup_range(j)
   ENDDO
ENDDO

! To write the POSCAR file

outpos_name='SUPPOS'

CALL writepos(outpos_name,     &
              pos_title,       &
              alat,            &
              supvect,         &
              ele_symbol,      & 
              ntype,           &
              sup_natom,       &
              sup_natomi,      & 
              ndynamic,        &
              ncoord,          &
              suppos,          &
              supfix)
            
! End of writing the POSCAR file

END SUBROUTINE supercell
