SUBROUTINE vstruc(volume,  &
                  alat,    &
                  privect)
!
!  Purpose:
!
!    To calculate the volume of the current structure
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    volume    : The volume of POS file
!    recipvect : The reciprocal matrix of privect(3,3)
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3)

! The variables for main program

DOUBLE PRECISION :: volume
DOUBLE PRECISION :: recipvect(3,3)

recipvect(1,1)=privect(2,2)*privect(3,3)-privect(3,2)*privect(2,3)
recipvect(1,2)=privect(2,3)*privect(3,1)-privect(3,3)*privect(2,1)
recipvect(1,3)=privect(2,1)*privect(3,2)-privect(3,1)*privect(2,2)

! Unit:A^3

volume=alat**3*(privect(1,1)*recipvect(1,1)+  &
                privect(1,2)*recipvect(1,2)+  &
                privect(1,3)*recipvect(1,3))

END SUBROUTINE vstruc
