SUBROUTINE writepos(outpos_name,     &
                    pos_title,       &
                    alat,            &
                    privect,         &
                    ele_symbol,      & 
                    ntype,           &
                    natom,           &
                    natomi,          & 
                    ndynamic,        &
                    ncoord,          &
                    pripos,          &
                    prifix)
!
!  Perpose:
!
!    To write the structure file with format "VASP"
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    inpos_mane: Name of input file
!    outpos_name: Name of output file
!
!    pos_title : 'name' of the system
!    alat      : A universal scaling factor, which is used to scale all lattice vectors and all atomaic coordinates
!    privect   : The vectors defining the unit cell of the system
!    ele_symbol: 
!    ntype     : Number of atomic type
!    natom     : Total number of atoms
!    natomi    : Number of atoms per atomic species
!    ndynamic  : Ndynamic=1: Selective Dynamics switched on; ndynamic=0: Selective Dynamics switched off
!    ncoord    : Ncoord=1: Cartesian mode; ncoord=0: Direct mode
!    pripos    : Three coordinates for each atom
!    prifix    : Three additional logical flags determining whether to allow changes of the coordinates or not
!    atom_type : Array for atomic type using in SPGLIB
!
!    pricoord  : 'C' or 'c': Cartesian mode; 'D' or 'd': Direct mode
!    select_dynamic: 'S' or 's': Selective Dynamics switched on
!


USE constants
IMPLICIT NONE

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: str_tmp
CHARACTER(len=30) :: outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=10) :: pricoord, select_dynamic
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

INTEGER :: pos_mode


! pos_mode=00: Direct and selestive off
! pos_mode=01: Direct and selestive on
! pos_mode=10: Cartesian and selestive off
! pos_mode=11: Cartesian and selestive on
pos_mode=ncoord*10+ndynamic

str_tmp=outpos_name

str_tmp=TRIM(str_tmp)//'!'
DO i=(LEN_TRIM(str_tmp)+1),30
   str_tmp(i:i)=' '
ENDDO

IF ( pos_mode .NE. 00 .AND. pos_mode .NE. 01 .AND. pos_mode .NE. 10 .AND. pos_mode .NE. 11 ) THEN
            
        OPEN(UNIT=19, POSITION='Append', FILE='OUTFILE')
        WRITE(19,*)        
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        WRITE(19,*) '|                                     ERROR                                   |'
        WRITE(19,*) '|                            -----------------------                          |'
        WRITE(19,*) '|    No such posmode an writing the POS file: ', str_tmp, '  |'
        WRITE(19,*) ' ----------------------------------------------------------------------------- '
        CLOSE(19)
        STOP

ENDIF

IF ( pos_mode .EQ. 00 ) THEN

        ! CALL directpos(atat,     &
        !                privect,  &
        !                natom,    &
        !                ncoord,   &
        !                pripos)

        pricoord='Direct'

        OPEN( UNIT = 10, FILE = TRIM(outpos_name), STATUS = 'unknown' )
        WRITE(10,'(A30)') pos_title
        WRITE(10,'(f12.10)') alat
        DO i=1, 3
           WRITE(10,'(3f20.12)')( privect(i,j), j=1,3 )
        ENDDO
        WRITE(10,'(10A5)') ( ele_symbol(i), i=1,ntype )
        WRITE(10,'(10I4)') ( natomi(i), i=1,ntype )
        WRITE(10,'(A6)') pricoord
        DO i=1, natom
           WRITE(10,'(3F20.10)') ( pripos(i,j), j=1,3 )
        ENDDO
        CLOSE(10)                   

ENDIF
        

IF ( pos_mode .EQ. 01 ) THEN

        ! CALL directpos(atat,     &
        !                privect,  &
        !                natom,    &
        !                ncoord,   &
        !                pripos)

        pricoord='Direct'
        select_dynamic='Selective'                

        OPEN( UNIT = 10, FILE = TRIM(outpos_name), STATUS = 'unknown' )
        WRITE(10,'(A30)') pos_title
        WRITE(10,'(F12.10)') alat
        DO i=1, 3
           WRITE(10,'(3F20.12)')( privect(i,j), j=1,3 )
        ENDDO
        WRITE(10,'(10A5)') ( ele_symbol(i), i=1,ntype )
        WRITE(10,'(10I4)') ( natomi(i), i=1,ntype )
        WRITE(10,'(A10)') select_dynamic
        WRITE(10,'(A6)') pricoord
        DO i=1, natom
           WRITE(10,'(3F20.10, 3A3)') ( pripos(i,j), j=1,3 ), ( prifix(i,j), j=1,3 )
        ENDDO
        CLOSE(10)

ENDIF


IF ( pos_mode .EQ. 10 ) THEN

        ! CALL cartepos(atat,     &
        !               privect,  &
        !               natom,    &
        !               ncoord,   &
        !               pripos)
        
        pricoord='Cartesian'

        OPEN( UNIT = 10, FILE = TRIM(outpos_name), STATUS = 'unknown' )
        WRITE(10,'(A30)') pos_title
        WRITE(10,'(f12.10)') alat
        DO i=1, 3
           WRITE(10,'(3f20.12)')( privect(i,j), j=1,3 )
        ENDDO
        WRITE(10,'(10A5)') ( ele_symbol(i), i=1,ntype )
        WRITE(10,'(10I4)') ( natomi(i), i=1,ntype )
        WRITE(10,'(A6)') pricoord
        DO i=1, natom
           WRITE(10,'(3F20.10)') ( pripos(i,j), j=1,3 )
        ENDDO
        CLOSE(10)
             
ENDIF
        

IF ( pos_mode .EQ. 11 ) THEN

        ! CALL cartepos(atat,     &
        !               privect,  &
        !               natom,    &
        !               ncoord,   &
        !               pripos)

        pricoord='Cartesian'
        select_dynamic='Selective'

        OPEN( UNIT = 10, FILE = TRIM(outpos_name), STATUS = 'unknown' )
        WRITE(10,'(A30)') pos_title
        WRITE(10,'(f12.10)') alat
        DO i=1, 3
           WRITE(10,'(3f20.12)')( privect(i,j), j=1,3 )
        ENDDO
        WRITE(10,'(10A5)') ( ele_symbol(i), i=1,ntype )
        WRITE(10,'(10I4)') ( natomi(i), i=1,ntype )
        WRITE(10,'(A10)') select_dynamic
        WRITE(10,'(A6)') pricoord
        DO i=1, natom
           WRITE(10,'(3F20.10, 3A3)') ( pripos(i,j), j=1,3 ), ( prifix(i,j), j=1,3 )
        ENDDO
        CLOSE(10)

ENDIF       

END SUBROUTINE writepos
