SUBROUTINE zvaluer(inpos_name, &
                   zvalue,     &
                   alat,       &
                   privect,    &
                   natom,      &
                   ncoord,     &
                   pripos)
!
!  Purpose:
!
!    To determine automatically a default value of zvalue (UNIT: Ang), for which there is a maximum
!    layer spacing, because the slip or cleavage plane with a large interlayer distance is 
!    always prone to gliding because of the weak interaction between the layers
!
!  Record of vevisions:
!      Data         Programmer        Description of change
!      ====         ==========        =====================
!   2017/03/17      Shihao Zhang      Original code
!
!  Variables:
!
!    zvaluevect: The coordinate of z axis of atoms 
!    zspacing  : The spacing of atomic layer
!    zvalue    : The determined zvalue with max zspacing, and the alias deformation will be applied to the atoms, whose z coordinate > zvalue
!
!
!
!

USE constants
IMPLICIT NONE

! The variables for reading and writing POS file

INTEGER :: i, j, k, ii, jj, kk
INTEGER :: ntype, natom, ncoord, ndynamic
INTEGER :: natomi(TYPEMAX), atom_type(ATOMMAX), atom_count(TYPEMAX+1)

DOUBLE PRECISION :: alat
DOUBLE PRECISION :: privect(3,3), pripos(ATOMMAX,3)

CHARACTER(len=30) :: inpos_name, outpos_name
CHARACTER(len=30) :: pos_title 
CHARACTER(len=2) :: ele_symbol(TYPEMAX)
CHARACTER(len=1) :: prifix(ATOMMAX,3)

! The variables for main program

INTEGER :: countnum, maxindex
DOUBLE PRECISION :: tmpz, zvalue
DOUBLE PRECISION :: zvaluevect(ATOMMAX), zspacing(ATOMMAX-1)

! To read the POSCAR file

CALL readpos(inpos_name,      &
             pos_title,       &
             alat,            &
             privect,         &
             ele_symbol,      & 
             ntype,           &
             natom,           &
             natomi,          & 
             ndynamic,        &
             ncoord,          &
             pripos,          &
             prifix,          &
             atom_type)

! End of reading the POSCAR file

! To carte
CALL cartepos(alat,     &
              privect,  &
              natom,    &
              ncoord,   &
              pripos)

! Rank pripos(i,3)

countnum=1
zvaluevect(1)=pripos(1,3)
DO i=2,natom
   j=1
   DO
      IF ( ABS(pripos(i,3)-pripos(j,3)) .LT. ZERO_TOLERANCE ) THEN
                EXIT
      ENDIF
      IF ( j .EQ. i-1 ) THEN
              countnum=countnum+1
              zvaluevect(countnum)=pripos(i,3)
              EXIT
      ENDIF
      j=j+1
   ENDDO
ENDDO

DO i=1,countnum-1
   DO j=i+1,countnum
      IF ( zvaluevect(j) .LT. zvaluevect(i) ) THEN
              tmpz=zvaluevect(j)
              zvaluevect(j)=zvaluevect(i)
              zvaluevect(i)=tmpz
      ENDIF
   ENDDO
ENDDO

zvaluevect(countnum+1)=zvaluevect(1)+privect(3,3)

DO i=1,countnum
   zspacing(i)=zvaluevect(i+1)-zvaluevect(i)
ENDDO

! max value of zspacing(i)

maxindex=1
DO i=1,countnum
        IF ( zspacing(i) .LT. (10.0000-ZERO_TOLERANCE) ) THEN
                maxindex=i
                EXIT
        ENDIF
ENDDO

DO i=(maxindex+1),countnum
   IF ( zspacing(i).GT.zspacing(maxindex) .AND. zspacing(i).LT.(10.0000-ZERO_TOLERANCE) ) THEN
           maxindex=i
   ENDIF
ENDDO

zvalue=(zvaluevect(maxindex+1)+zvaluevect(maxindex))/2

END SUBROUTINE zvaluer
