% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[];
    SFE=[];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=6;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=[];
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=[];
    poisson_ratio=[];
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=0;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  1.0000,  1/Nmis];
    Xdist_range=[-50.0000, 50.0000,  0.0000];
    Xwid_range =[  0.0000, 10.0000,  5.0000];
    Xalpha_range=[ 0.0000,  2.0000,  1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_fitting_toolbox';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=1;
 
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='TRUE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
