
% ------------------------------------------------------------------------
% Function: misfit1d ( x )
% ------------------------------------------------------------------------
% Aim:
% The disregistry vector for one dimension P-N model
% ------------------------------------------------------------------------

function Ux = misfit1d(x)

% Defining global variables

    global BurVect;
    global Nmis;
    global Xcoef Xdist Xwid Xalpha;
    global mis_1st;

% The misfit function    
    
    temp=0;

    % % misfunc_1st: 0: without 1st; 1: with 1st
    
    if mis_1st==0

        for m=1:Nmis
            temp=temp+BurVect/pi*Xcoef(m).*atan((x+Xdist(m))/Xwid(m));
        end
    
    elseif mis_1st==1
        
        for m=1:Nmis
            temp=temp+BurVect/pi*Xcoef(m).*(atan((x+Xdist(m))/Xwid(m))+(1-Xalpha(m))*Xwid(m)*(x-Xdist(m))./((x-Xdist(m)).^2+(Xalpha(m)*Xwid(m))^2));
        end
        
    end
    
    Ux=temp+BurVect/2;
    
end
