
% ------------------------------------------------------------------------
% Function: fitfuncABC( ux, Xcoef, Xdist, Xwid )
% ------------------------------------------------------------------------
% Aim:
% The function of elastic resistance to fit the restoring force 
% ------------------------------------------------------------------------

function F_el = fitfuncABC( ux, Xcoef, Xdist, Xwid )

    global BurVect Kx;

    Xcoef=Xcoef/sum(Xcoef);

    xxx=arrayfun(@(ux_i)fsolve(@(xx)BurVect*(1/2+1/pi*sum(Xcoef.*atan((xx-Xdist)./Xwid)))-ux_i,0, optimset('Display','off')),ux);

    F_el=zeros(size(xxx,1),1);
    
    for i=1:size(xxx,1)
        
        F_el(i)=Kx*BurVect/(2*pi)*sum(Xcoef.*(xxx(i)-Xdist)./((xxx(i)-Xdist).^2+Xwid.^2));
    
    end

    % F_el=zeros(size(xxx,1),1);
    % 
    % for i=1:size(xxx,1)
    % 
    %     intfunc=@(x_t)arrayfun(@(x_t_i)(BurVect/pi)*(1./(xxx(i)-x_t_i))*sum(Xcoef.*Xwid./((x_t_i-Xdist).^2+Xwid.^2)),x_t);
    % 
    %     F_el(i)=Kx/(2*pi)*(quadgk(intfunc,-inf,xxx(i)-1e-6,'RelTol',1e-8,'AbsTol',1e-12)+quadgk(intfunc,xxx(i)+1e-6,inf,'RelTol',1e-8,'AbsTol',1e-12));
    % 
    % end
                  
end


