
% ------------------------------------------------------------------------
% Function: fitfuncABCx( coef, ux )
% ------------------------------------------------------------------------
% Aim:
% The function of elastic resistance to fit the restoring force 
% ------------------------------------------------------------------------

function F_el = fitfuncABCx( coef, ux )

    global BurVect Kx;
    global Nmis;

    Xcoef=coef(1:Nmis)/sum(coef(1:Nmis));
    if Nmis==1
        Xdist=0;
    elseif Nmis>=2
        Xdist=coef(Nmis+1:2*Nmis-1);
        Xdist(Nmis)=-sum(Xdist(1:Nmis-1));
    end
    Xwid=coef(2*Nmis:3*Nmis-1);


    xxx=arrayfun(@(ux_i)fsolve(@(xx)BurVect*(1/2+1/pi*sum(Xcoef.*atan((xx-Xdist)./Xwid)))-ux_i,0, optimset('Display','off')),ux);

    F_el=zeros(size(xxx,1),1);

    for i=1:size(xxx,1)

        F_el(i)=Kx*BurVect/(2*pi)*sum(Xcoef.*(xxx(i)-Xdist)./((xxx(i)-Xdist).^2+Xwid.^2));

    end

end


