
% ------------------------------------------------------------------------
% Function: Gamma ( x )
% ------------------------------------------------------------------------
% Aim:
% The function of GSFE or gamma surface for 2D P-N model
% ------------------------------------------------------------------------
% Ref:
% 1/ Schoeck, Gunther. Philosophical Magazine A 81.5 (2001): 1161-1176.
% ------------------------------------------------------------------------

function gamma = Gamma(x)

    % Defining global variables

    global BurVect;
    global gammafitresult;
       
    % Some parameters

    P=2*pi/sqrt(3)/BurVect;
    Q=2*pi/BurVect;
    
    Ux=misfit_x(x);
    Uz=misfit_z(x);
    
    % the unit of gamma surface: J/m2

        % % Three methods with poor efficiency

            % % % The first method

            % temp_AA=coeffnames(gammafunc);
            % temp_BB=coeffvalues(gammafunc);
            % 
            % for ii=1:numcoeffs(gammafunc)
            %     eval([eval('temp_AA{ii}'),'=temp_BB(ii);']);
            % end

            % Ux=Q*misfit_x(x)/(2*pi);
            % Uz=P*misfit_z(x)/(2*pi); 

            % gamma=eval(formula(gammafunc));

            % % % The second method

            % gamma=feval(gammafunc,Q*Ux/(2*pi),P*Uz/(2*pi));

            % % % The third method

            % gamma=gammafunc(Q*Ux/(2*pi),P*Uz/(2*pi));

        % % The method with high efficiency (the 'gammafitresult' is defined 
        %   in the file of 'StartCal.m')

        gamma=gammafitresult(Q*Ux/(2*pi),P*Uz/(2*pi));
    
end

