
% ------------------------------------------------------------------------
% Function: Epoten ( Input )
% ------------------------------------------------------------------------
% Aim: 
% The potential energy decrease due to favorable solute fluctuations
% ------------------------------------------------------------------------
% Ref:
% 1/ Leyson, G. P. M., L. G. Hector, and W. A. Curtin. Acta Materialia 60.13 (2012): 5197-5203.
% 2/ Leyson, G. P. M., L. G. Hector, and W. A. Curtin. Acta Materialia 60.9 (2012): 3873-3884.
% ------------------------------------------------------------------------

function [ Ep ] = Epoten( w )

    % define the global parameters
    
    global eb es;
    global pressfld_latxz_mis pressfld_latyy_mis;   
    
    % range of lattice x and y 

        function [ subChi ] =subChi(wk,yk,locat_yk)

            up=0;
            down=0;

            for xk=pressfld_latxz_mis(locat_yk,:)
                up=up+Einact(xk-wk,yk,eb,es)*Einact(xk,yk,eb,es);
                down=down+Einact(xk,yk,eb,es)^2;
            end
            
            if down~=0
                subChi=up/down;
            else
                subChi=0;
            end

        end

    % potential energy decrease Ep due to favorable solute fluctuations( 1E-20*J )

        temp=zeros(size(pressfld_latxz_mis,1),size(pressfld_latxz_mis,2));

        for ii=1:size(pressfld_latxz_mis,1)
            for jj=1:size(pressfld_latxz_mis,2)
                temp(ii,jj)=(1-subChi(w,pressfld_latyy_mis(ii,jj),ii))*Einact(pressfld_latxz_mis(ii,jj),pressfld_latyy_mis(ii,jj),eb,es)^2;
            end
        end

        Ep=sqrt(2*sum(sum(temp)));

end

