path=mfilename('fullpath');                                         %ǰļĿ¼
path = path(1:max(regexp(path,'\'))-1);                             %ȡļĿ¼
cd(path);

filename = 'NTA/NTA_B.lmp';
outname = 'Gallery/NTA_B.jpg';


prop = [ 3 4 5 8 ];     move = [0 0];       barr = [0 0.12 0 0.03 0.12];
r = [ 281 30/2 285 30/2 10 2.48/2 ];        shrink = [2 2];
XLabel = 'NTA_B X (nm)';  YLabel = 'Y (nm)';  

cut = [r(1)-r(2) r(1)+r(2) r(3)-r(4) r(3)+r(4) r(5)-r(6) r(5)+r(6)];
lpos = [cut(1)+shrink(1) cut(2)-shrink(1) cut(3)+shrink(2) cut(4)-shrink(2)];
lstr = [ 0 cut(2)-cut(1) 5 0 cut(4)-cut(3) 5 ];

atoms = dlmread(filename,'',9,0);   p = atoms(:, prop);
select = p(:,1) > cut(1) & p(:,1) < cut(2) & p(:,2) > cut(3) & p(:,2) < cut(4) & p(:,3) > cut(5) & p(:,3) < cut(6);
p = p(select, :);   x = p(:, 1)'+move(1);     y = p(:, 2)'+move(2);     s =  p(:, 4)'; 



figure1 = figure('Position',[100 100 800 600],'visible','on');

axes1 = axes('Parent',figure1, 'Position',[0.1 0.12 0.8 0.8]);  hold(axes1,'on'); axes1.Box='On';
axes1.XLim = lpos(1:2);                 axes1.YLim = lpos(3:4);
axes1.FontName = 'Times';               axes1.FontSize = 16;        axes1.TickDir = 'out';
axes1.XLabel.String = XLabel;   axes1.XLabel.FontName = 'Times';
axes1.YLabel.String = YLabel;   axes1.YLabel.FontName = 'Times';
axes1.XTick = (lpos(1):lstr(3):lpos(2))'; 
axes1.XTickLabel = num2str((lstr(1):lstr(3):lstr(2))'/10,'%.1f');
axes1.YTick = (lpos(3):lstr(6):lpos(4))'; 
axes1.YTickLabel = num2str((lstr(4):lstr(6):lstr(5))'/10,'%.1f');


axes1.PlotBoxAspectRatio = [480 480 20];

%Trif = delaunay(x,y);trisurf(Trif,x,y,-ones(1,size(x,2)),s,'Parent',axes1);    hold on;
%hold on;shading interp;view([0 0 1]);
[X,Y,Z]=griddata(x,y,s,linspace(cut(1),cut(2),100)',linspace(cut(3),cut(4),100),'v4');%ֵ
pcolor(X,Y,Z,'Parent',axes1);shading interp                                            %αɫͼ

p = plot3(x,y,ones(1,size(x,2)).*0.5,'o', 'MarkerSize',7, 'MarkerEdgeColor','k'...
    ,'MarkerFaceColor',[1 1 1],'LineWidth', 1,'Parent',axes1);hold on;

caxis(barr(1:2));       Ticks = (barr(3):barr(4):barr(5))';%c.Limits = [0.0 1.0];
c = colorbar('Ticks',Ticks,'TickLabels',cellstr( num2str(Ticks,'%.2f ')));
colormap(jet);          c.FontName = 'Times';

print('-djpeg','-r100', outname);

