path=mfilename('fullpath');                                         %ǰļĿ¼
path = path(1:max(regexp(path,'\'))-1);                             %ȡļĿ¼
cd(path);

filename = 'Mg';
NYEfilename = '../NYE/NYE.22.lmp_ntensor';turn = 1;

colorstr = 'k';
selectr = [4.8 9.8];    ratio = 100;     center = 1;   magr = 0.001;
axisr = [0 10 40 0 5 15];    divi = 10;
xstr = '        X [1120]\fontsize{20}_{Mg}\fontsize{25} (nm)';
ystr = 'Z [0001]\fontsize{20}_{Mg}\fontsize{25} (nm)';
move = [-16 -13];
r = 0.45;  change = 1;      Fi = 13;       mult = 1; %% ͷ Ƕ  0.8

line = [ 3 4 5 14];    barr = [-0.03 0.03 -0.03 0.02 0.03];
if(turn==2)line = [ 3 4 5 12];barr = [-0.05 0.05 -0.05 0.05 0.05];mult = 3;
end

atoms = dlmread(NYEfilename,'',9,0);
select = atoms(:,line(3)) > selectr(1) & atoms(:,line(3)) < selectr(2);
x=atoms(select,line(1))'+move(1);y=atoms(select,line(2))'+move(2);s=atoms(select,line(4))';if(turn==12)s=-s;end
minx = min(x);maxx = max(x);miny = min(y);maxy = max(y);


figure1 = figure('Position',[00 70 960 720],'Units','centimeters');

% [X,Y,Z]=griddata(x,y,s,linspace(minx,maxx,ratio)',linspace(miny,maxy,ratio),'v4');%ֵ
% pcolor(X,Y,Z);shading interp%αɫͼ
z = ones(1,size(x,2)).*-1;
Trif = delaunay(x,y);trisurf(Trif,x,y,z,s);hold on;
hold on;shading interp;view([0 0 1]);
% ԭ С ϸ

p = plot3(x,y,ones(1,size(x,2)).*0.5,'o', 'MarkerSize',9, 'MarkerEdgeColor','k'...
    ,'MarkerFaceColor',[1 1 1],'LineWidth', 1);hold on;
%%
atoms = dlmread('../DDA/DDA.lmp','',9,0); 
line = [ 3 4 5 2 9 10];  width = 2;
if(turn==2)line = [ 3 4 5 2 6 7];width = 2;end

select = atoms(:,line(5)).^2 + atoms(:,line(6)).^2 > magr & atoms(:,line(4)) >= 100;
if(turn==2) select = select & atoms(:,line(5)) >= 0;end
x=atoms(select,line(1))'+move(1);y=atoms(select,line(2))'+move(2);
u=atoms(select,line(5))';v=atoms(select,line(6))';

%%
Fi = Fi*pi/180;
if(center) u = u.*(mult/2);v = v.*(mult/2);r = r*2;
else u = u.*mult;v = v.*mult;end

%%
ang = atan2(v,u);
mag = sqrt(u.^2 + v.^2);
if(change)    magr = mag.*r;
else    magr = r;   end
mags = mag - magr;
us = u- magr.*cos(ang);
vs = v- magr.*sin(ang);

tt  = atan(magr./mags*tan(Fi));
P1x = x+mags./cos(tt).*cos(ang+tt);
P2x = x+mags./cos(tt).*cos(ang-tt);
P1y = y+mags./cos(tt).*sin(ang+tt);
P2y = y+mags./cos(tt).*sin(ang-tt);
su=[x+u;P1x;P2x];
sv=[y+v;P1y;P2y];

patch(su,sv,colorstr,'EdgeAlpha', 1);hold on;
if(center) lx = [x-u;x+us;ones(1,size(x,2)).*nan];lx = lx(:);
ly = [y-v;y+vs;ones(1,size(y,2)).*nan];ly = ly(:);
else lx = [x;x+us;ones(1,size(x,2)).*nan];lx = lx(:);
ly = [y;y+vs;ones(1,size(y,2)).*nan];ly = ly(:);
end
patch(lx, ly, colorstr,'EdgeColor',colorstr,'MarkerFaceColor',colorstr, 'LineWidth', width);


%% colorbar ѡΧ ֱ ȷΧ
caxis(barr(1:2));Ticks = (barr(3):barr(4):barr(5))';%c.Limits = [0.0 1.0];
c = colorbar('Ticks',Ticks,'TickLabels',cellstr( num2str(Ticks,'%.2f ')));
colormap(jet);	c.FontName = 'Times';

% 귶Χ ͼΧ 
hold(gca,'on');box(gca,'on');grid(gca,'on');
axis equal;xlim(gca,[axisr(1) axisr(3)]);ylim(gca,[axisr(4) axisr(6)]);
set(gca,'FontName','Times New Roman','fontsize',25, 'LineWidth',1.5,'TickDir','out');
Ticks = (axisr(1):axisr(2):axisr(3))'; set(gca,'XTick',Ticks,'XTickLabels', cellstr( num2str(Ticks./divi,'%4.1f')));
Ticks = (axisr(4):axisr(5):axisr(6))'; set(gca,'YTick',Ticks,'YTickLabels', cellstr( num2str(Ticks./divi,'%4.1f')));
xlabel(xstr,'fontsize',25);ylabel(ystr,'fontsize',25);

if(turn == 1)print('-dpng','-r300',[filename,'.1.png']);else print('-dpng','-r300',[filename,'.2.png']);end