#! /bin/bash

# A bash shell is used to elastic constants in batches
# A directory named "FILE" is needed including "${file}" file and "structure" directory. And the structure files to calculated are including in the "structure" directory

# The file name of bash shell that realizes the pre-processing, first-principles calculations and post-processing

# Such as /example/Diamond/example.sh for 3D materials
# Such as /example/Graphene/example2d.sh for 2D materials
file='example3d.sh'
#file='example2d.sh'

# the name of structure file to calculated
for ii in diamond graphene
do

# Create directories and copy the structure file to calculated to the corresponding directory
mkdir ${ii}
mkdir ./${ii}/structure
cp ./FILE/structure/${ii}.vasp ./${ii}/structure/

# substitute the character "structure_file" in file "./FILE/${file}" using "${ii}"
sed "s/structure_file/${ii}/" ./FILE/${file} > ./${ii}/${file}

# To submit job

cd ${ii}
chmod +x ${file}
qsub ${file}
cd ..


## the name of structure file (from POS_001 to POS_100) to calculated
#for ii in `seq -w 001 001 100`
#do

## Create directories and copy the structure file to calculated to the corresponding directory

#mkdir POS_${ii}
#mkdir ./POS_${ii}/structure
#cp ./FILE/structure/POS_${ii}.vasp ./POS_${ii}/structure/

## substitute the character "structure_file" in file "./FILE/${file}" using "${ii}"
#sed "s/structure_file/POS_${ii}/" ./FILE/${file} > ./POS_${ii}/${file}

## To submit job

#cd POS_${ii}
#chmod +x ${file}
#qsub ${file}
#cd ..

done
