#!/bin/bash

for SYS_name in structure_file
do

#>>> create POTCAR file
cat ~/POTLDA/POT_xxx > ./POTCAR

#>>> create INCAR file using AELAS and the file incar_rlx and incar_stc are created

#>>> the pressure in 0GPa (default value)
~/code/AELAS/bin/AELAS --incar

#>>> and the pressure is 100GPa
#~/code/AELAS/bin/AELAS --incar 100


#>>> create POSCAR file using ALEAS and the file pos_{n1}_{n2}.vasp are created

cp ./structure/${SYS_name}.vasp ./INPOS
~/code/AELAS/bin/AELAS --generate
nelastic=$( ls POS_*_001.vasp | wc -l )


#>>> create KPOINTS file using AELAS and the file NEWKPT are created

#~/code/AELAS/bin/AELAS -k 10 10 10
#>>> the type mesh to use: Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
#~/code/AELAS/bin/AELAS -k 10 10 10 Gamma

#>>> KPPRA=1000(default value)
#~/code/AELAS/bin/AELAS -ka
~/code/AELAS/bin/AELAS -ka 4000
#>>> the type mesh to use: Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
#~/code/AELAS/bin/AELAS -ka 1000 Gamma

#>>> KSPACING=0.5(default value)
#~/code/AELAS/bin/AELAS -kv
#~/code/AELAS/bin/AELAS -kv 0.5
#>>> the type mesh to use: Gamma-centered ('G':defult value) or Monkorst-Pack ('M')
#~/code/AELAS/bin/AELAS -kv 0.5 Gamma

cp NEWKPT KPOINTS


for k in `seq -w 01 ${nelastic}`
do
for m in `seq -w 001 013`
do

cp ./POS_${k}_${m}.vasp POSCAR

#>>> To run the VASP
#>>> To relax the atomic position
cp incar_rlx INCAR
~/bin/vasp541 >> olog.vasp

#>>> To calculate the energy
cp incar_stc INCAR
cp CONTCAR POSCAR
~/bin/vasp541 >> olog.vasp

#>>> save the energy file
cp OSZICAR OSZICAR_${k}_${m}

done
done

#cp ./structure/${SYS_name}.vasp ./INPOS
~/code/AELAS/bin/AELAS --derive

#>>> And the result of elastic constants is contained in the file "ELADAT"

done

rm POSCAR KPOINTS* INCAR* POTCAR
rm CHG* CONTCAR DOSCAR OSZICAR OUTCAR EIGENVAL PCDAT WAVECAR XDATCAR IBZKPT openmpi.log vasprun.xml
rm OLDPOS

#>>> make clean
#~/code/AELAS/bin/AELAS --clean

#END
