C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C-->        Subroutine "cartepos" is used to transform         %%%%
C-->      fractional coordinates to cartesian coordinates      %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

        subroutine cartepos(alat,
     &                      privect,
     &                      nn,
     &                      Ncoord,
     &                      pripos)

        double precision alat,pripos,privect
        dimension privect(3,3),pripos(1000,3)
        integer i,j,k,ntype,nn
        integer Ncoord,natomi
        dimension natomi(10)

        double precision transvect, pos
        dimension transvect(3,3), pos(1000,3), IS(3), JS(3)

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%              defect the transvect matrix                %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do i=1,3
           do j=1,3
              transvect(i,j)=privect(i,j)*alat
           enddo
        enddo
        if (Ncoord .EQ. 1) THEN
                call brinv(transvect,3,L,IS,JS)
        endif

        if (Ncoord .NE. 0 .AND. Ncoord .NE. 1) THEN
                open(unit=19,position='Append',FILE='RELAS') 
                write(19,*) 'ERROR!! NOT DIRECT OR CARTESIAN!!!'
                close(19)
                stop
        endif
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%%%%%             transform the coordinate                %%%% 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        if (Ncoord .EQ. 0) THEN
                do i=1,nn
                   do j=1,3
                      pos(i,j)=0.0
                      do k=1,3
                         pos(i,j)=pos(i,j)+pripos(i,k)*transvect(k,j)
                      enddo
                   enddo
                enddo
        
                do i=1,nn
                   do j=1,3
                      pripos(i,j)=pos(i,j)
                   enddo
                enddo
        endif

        end

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                  End of cartepos.f                      %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
