C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%   subprogram "cjcbj" is used to solve the matrix        %%%% 
C%%%%%   eigenvalues according the Jacobi iterate method       %%%%
C%%%%                           REFERENCE                      %%%%
C%%%%    1\ FORTRAN changyongsuanfachengxuji, XuShilang        %%%%      
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        SUBROUTINE cjcbj(A,N,EPS,V)
        DIMENSION A(N,N),V(N,N)
        DOUBLE PRECISION A,V,FF,FM,CN,SN,OMEGA,X,Y
        INTEGER P,Q
        DO 2020 I=1,N
          V(I,I)=1.0
          DO 2010 J=1,N
            IF (I.NE.J) V(I,J)=0.0
2010        CONTINUE
2020      CONTINUE
        FF=0.0
        DO 2500 I=2,N
        DO 2500 J=1,I-1
2500     FF=FF+A(I,J)*A(I,J)
        FF=SQRT(2.0*FF)
2205     FF=FF/(1.0*N)
2025      DO 2030 I=2,N
        DO 2030 J=1,I-1
          IF (ABS(A(I,J)).GE.FF) THEN
            P=I
            Q=J
            GOTO 2600
          END IF
2030      CONTINUE
        IF (FF.GE.EPS) GOTO 2205
        RETURN
2600     X=-A(P,Q)
        Y=(A(Q,Q)-A(P,P))/2.0
        OMEGA=X/SQRT(X*X+Y*Y)
        IF (Y.LT.0.0) OMEGA=-OMEGA
        SN=1.0+SQRT(1.0-OMEGA*OMEGA)
        SN=OMEGA/SQRT(2.0*SN)
        CN=SQRT(1.0-SN*SN)
        FM=A(P,P)
        A(P,P)=FM*CN*CN+A(Q,Q)*SN*SN+A(P,Q)*OMEGA
        A(Q,Q)=FM*SN*SN+A(Q,Q)*CN*CN-A(P,Q)*OMEGA
        A(P,Q)=0.0
        A(Q,P)=0.0
        DO 2060 J=1,N
          IF ((J.NE.P).AND.(J.NE.Q)) THEN
            FM=A(P,J)
            A(P,J)=FM*CN+A(Q,J)*SN
            A(Q,J)=-FM*SN+A(Q,J)*CN
          END IF
2060      CONTINUE

        DO 2070 I=1,N
          IF ((I.NE.P).AND.(I.NE.Q)) THEN
            FM=A(I,P)
            A(I,P)=FM*CN+A(I,Q)*SN
            A(I,Q)=-FM*SN+A(I,Q)*CN
          END IF
2070      CONTINUE
        DO 2080 I=1,N
          FM=V(I,P)
          V(I,P)=FM*CN+V(I,Q)*SN
          V(I,Q)=-FM*SN+V(I,Q)*CN
2080      CONTINUE
        GOTO 2025
        END
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                     End of cjcbj.f                      %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
