C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C-->       Subroutine "def4elas" is used to deform the cell    %%%%
C-->       vectors with strains for the calculation of         %%%%
C-->       elastic constants                                   %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        subroutine def4elas(DefVect, num, strnum)

        integer num, strnum
        real DefVect
        dimension DefVect(6)
        
        double precision alat,pripos,privect
        dimension privect(3,3),pripos(1000,3)
        character*10 title,fix
        character*15 pricoord,seldyn
        character*5 sname
        character*10 inpos
        dimension sname(10),fix(1000,3)
        integer i,j,k,ntype,natomi,nn
        integer Ncoord,Ndyn,atom_types,anum
        dimension natomi(10),atom_types(1000),anum(11)        
        
        double precision strvect,strten
        dimension strvect(3,3),strten(3,3) 
        character*15 Filename


        inpos='RECELL'

        call readpos(inpos,
     &               title, 
     &               alat, 
     &               privect, 
     &               sname,
     &               natomi,                
     &               ntype,
     &               nn,  
     &               Ndyn,
     &               Ncoord,
     &               pripos,
     &               fix,
     &               atom_types)

        if (Ncoord .EQ. 1 .OR. Ncoord .EQ. 0) THEN
                call directpos(alat,
     &                        privect,
     &                        nn,
     &                        Ncoord,
     &                        pripos)
                Ncoord=0
        else
                open(unit=19,position='Append',FILE='RELAS')
                write(19,*) 'ERROR!! NOT DIRECT OR CARTESIAN!!!'
                close(19)
                stop
        endif

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%%%%% Define the strain tensor matrics                    %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        strten(1,1)=DefVect(1)+1.0 
        strten(1,2)=0.5*DefVect(6) 
        strten(1,3)=0.5*DefVect(5) 
        strten(2,1)=0.5*DefVect(6) 
        strten(2,2)=DefVect(2)+1.0 
        strten(2,3)=0.5*DefVect(4) 
        strten(3,1)=0.5*DefVect(5) 
        strten(3,2)=0.5*DefVect(4) 
        strten(3,3)=DefVect(3)+1.0
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%%%% Transform the cell vector to new vector under strain %%%%
C%%%%%%%%	strvect(i,j)=privect(i,j)(I+strten(i,j))       %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do k=1,3
           do i=1,3
              strvect(i,k)=0.0
              do j=1,3
                 strvect(i,k)=strvect(i,k)+privect(i,j)*strten(j,k)
              enddo
           enddo 
        enddo
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%      Create the POSCAR after defrom                      %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        write(Filename,'(a4,i02.2,a1,i03.3,a5)') 
     &                                'POS_',num,'_',strnum,'.vasp'

        posmode=00

        call writepos(posmode,
     &                Filename,                           
     &                title, 
     &                alat, 
     &                strvect, 
     &                sname,
     &                natomi,                
     &                ntype,
     &                nn,
     &                Ndyn,
     &                Ncoord,        
     &                pripos,
     &                fix,
     &                atom_types)   

        end 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                   End of def4elas.f                     %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
