C--------------------------------------------------------------%%%%
C-->     Subroutine "generate2d" is used to generate the files %%%%
C-->     with various kinds of deformation used in the first   %%%%
C-->     principle calculation for 2D material                 %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine generate2d

        use constant
        implicit none                
        
        integer spgmode, nelastic
        integer spgnum, ntype

        character*10 inpos

        inpos='INPOS'
        call symmetry(spgnum, inpos)

C       Oblique system
C       2D space group: p1, p2
C       (6 independent elastic constants)      

        if (spgnum .GE. 3 .AND. spgnum .LE. 15) then
                nelastic=6
                spgmode=1
        endif

C       Rectanglar system
C       2D space group: pm, pg, p2mm, p2gg, p2mg, cm, c2mm      
C       (4 independent elastic constants)  

        if (spgnum .GE. 16 .AND. spgnum .LE. 74) then
                nelastic=4
                spgmode=2
        endif

C       Square system
C       2D space group: p4, p4mm, p4gm
C       (3 independent elastic constants)

        if (spgnum .GE. 75 .AND. spgnum .LE. 142) then
                nelastic=3
                spgmode=3
        endif

C       Hexagon system
C       2D space group: p3, p6, p3m1, p31m, p6mm
C       (2 independent elastic constants)  

        if (spgnum .GE. 143 .AND. spgnum .LE. 194) then
                nelastic=2
                spgmode=4
        endif

        call recell2d

        call writedef(2, 
     &                spgmode, 
     &                nelastic, 
     &                spgnum)        

        select case (spgmode)
               case(1)
                 call Tri2dg(nelastic)
               case(2)
                 call Rect2dg(nelastic)
               case(3)
                 call Squa2dg(nelastic)
               case(4)
                 call Hexa2dg(nelastic)
        end select

        end
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                   End of mian program                   %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                        Oblique system
C%%%%%               (6 independent elastic constants)
C%%%%%                        c11  c12  c16
C%%%%%                        c12  c22  c26
C%%%%%                        c16  c26  c66 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        subroutine Tri2dg(nelastic)

        use constant
        implicit none                
        
        integer i, j, k
        integer nelastic
        real DefVect, strain
        dimension DefVect(6)
        real,dimension(:,:),allocatable:: DefMat        

        do i=1,ndef
           strain=defdata(i)
           allocate(DefMat(6,nelastic))
           DefMat(:,:)=reshape((/strain, 0.0, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, strain, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, 0.0, 0.0, 0.0, 0.0, strain,
     &                           strain, strain, 0.0, 0.0, 0.0, 0.0,
     &                           strain, 0.0, 0.0, 0.0, 0.0, strain,
     &                           0.0, strain, 0.0, 0.0, 0.0, strain
     &                                                /),(/6,nelastic/))

           do j=1,nelastic
              do k=1,6
                 DefVect(k)=DefMat(k,j)
              enddo
              call def4elas(DefVect, j, i)
           enddo
           deallocate(DefMat)
        enddo
        end

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                      Rectanglar system
C%%%%%               (4 independent elastic constants)
C%%%%%                        c11  c12    0
C%%%%%                        c12  c22    0
C%%%%%                          0    0  c66
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
        subroutine Rect2dg(nelastic)

        use constant
        implicit none        

        integer i, j, k
        integer nelastic
        real DefVect, strain
        dimension DefVect(6)
        real,dimension(:,:),allocatable:: DefMat        

        do i=1,ndef
           strain=defdata(i)
           allocate(DefMat(6,nelastic))
           DefMat(:,:)=reshape((/strain, 0.0, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, strain, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, 0.0, 0.0, 0.0, 0.0, strain,
     &                           strain, strain, 0.0, 0.0, 0.0, 0.0
     &                                                /),(/6,nelastic/))

           do j=1,nelastic
              do k=1,6
                 DefVect(k)=DefMat(k,j)
              enddo
              call def4elas(DefVect, j, i)
           enddo
           deallocate(DefMat)
        enddo
        end

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                        Square system
C%%%%%               (3 independent elastic constants)
C%%%%%                        c11  c12    0
C%%%%%                        c12  c11    0
C%%%%%                          0    0  c66 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
        subroutine Squa2dg(nelastic)

        use constant
        implicit none        

        integer i, j, k
        integer nelastic
        real DefVect, strain
        dimension DefVect(6)
        real,dimension(:,:),allocatable:: DefMat        

        do i=1,ndef
           strain=defdata(i)
           allocate(DefMat(6,nelastic))
           DefMat(:,:)=reshape((/strain, strain, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, 0.0, 0.0, 0.0, 0.0, strain,
     &                           strain, 0.0, 0.0, 0.0, 0.0, 0.0
     &                                                /),(/6,nelastic/))

           do j=1,nelastic
              do k=1,6
                 DefVect(k)=DefMat(k,j)
              enddo
              call def4elas(DefVect, j, i)
           enddo
           deallocate(DefMat)
        enddo
        end

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                       Hexagon system
C%%%%%               (2 independent elastic constants)
C%%%%%                        c11  c12    0
C%%%%%                        c12  c11    0
C%%%%%                          0    0  c66=(c11-c12)/2 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine Hexa2dg(nelastic)

        use constant
        implicit none        

        integer i, j, k
        integer nelastic
        real DefVect, strain
        dimension DefVect(6)
        real,dimension(:,:),allocatable:: DefMat        

        do i=1,ndef
           strain=defdata(i)
           allocate(DefMat(6,nelastic))
           DefMat(:,:)=reshape((/strain, strain, 0.0, 0.0, 0.0, 0.0,
     &                           0.0, 0.0, 0.0, 0.0, 0.0, strain
     &                                                /),(/6,nelastic/))

           do j=1,nelastic
              do k=1,6
                 DefVect(k)=DefMat(k,j)
              enddo
              call def4elas(DefVect, j, i)
           enddo
           deallocate(DefMat)
        enddo
        end

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                    End of generate2d.f                  %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

