C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%   Subroutine "incarx" is used to crear INCAR file the    %%%% 
C%%%%   calculation of vasp                                    %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine incarx(pressure)

        integer pressure

        open(unit = 11, file = 'incar_rlx', status = 'unknown')

        write(11,'(a8)') 'ISTART=0'
        write(11,'(a8)') 'ICHARG=2'
        write(11,'(a13)') 'PREC=Accurate'
        write(11,*)
        write(11,'(a23)') '# Electronic relaxation'
        write(11,'(a9)') 'ENCUT=520'
        write(11,'(a10)') 'EDIFF=1E-6'
        write(11,*)
        write(11,'(a8)') 'ISMEAR=0'
        write(11,'(a10)') 'SIGMA=0.01'

C        if ( nn .GE. 18) THEN
C                write(11,'(a10)') 'LREAL=Auto'
C        else
C                write(11,'(a13)') 'LREAL=.FALSE.'
C        endif

        write(11,'(a8)') 'NELMIN=5'
        write(11,*)
        write(11,'(a18)') '# Ionic relaxation'
        write(11,'(a6)') 'NSW=50'
        write(11,'(a12)') 'EDIFFG=-1e-3'
        write(11,'(a6)') 'ISIF=2'  
        write(11,*)
        write(11,'(a8)') 'IBRION=2' 
        write(11,'(a9)') 'POTIM=0.5'
        
        if ( pressure .GT. 0 ) THEN
                write(11,*)
                write(11,'(a12)') '# Other Tags'
                write(11,'(a8,i5)') 'PSTRESS=', pressure
        endif

        write(11,*)
        write(11,'(a13)') '# Write flags'
        write(11,'(a13)') 'LWAVE=.FALSE.'
        write(11,'(a14)') 'LCHARG=.FALSE.'

        close(11)

        open(unit = 21, file = 'incar_stc', status = 'unknown')

        write(21,'(a8)') 'ISTART=0'
        write(21,'(a8)') 'ICHARG=2'
        write(21,'(a13)') 'PREC=Accurate'
        write(21,*)
        write(21,'(a23)') '# Electronic relaxation'
        write(21,'(a9)') 'ENCUT=520'
        write(21,'(a10)') 'EDIFF=1E-6'
        write(21,*)
        write(21,'(a9)') 'ISMEAR=-5'
        
        if ( pressure .GT. 0 ) THEN
                write(21,*)
                write(21,'(a12)') '# Other Tags'
                write(21,'(a8,i5)') 'PSTRESS=', pressure
        endif

        write(21,*)
        write(21,'(a13)') '# Write flags'
        write(21,'(a13)') 'LWAVE=.FALSE.'
        write(21,'(a14)') 'LCHARG=.FALSE.'

        close(21)

        end
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                      end of incarx.f                     %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      
