C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C-->   subroutine "kpt" is used to create the KPOINTS file     %%%%
C-->   according the input of user                             %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        subroutine kpt(kmesh, kscheme)

        integer kmesh
        character*1 kscheme
        dimension kmesh(3)

        integer i

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                 writing the KPOINTS file                 %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        open(unit=19,position='Append',FILE='RELAS') 

        write(19,*) '  -----------------------------------------'
        write(19,'(A14)')  'Automatic mesh'
        write(19,'(A3)') '  0'
        if(kscheme.EQ.'m' .OR. kscheme.EQ.'M') then
                write(19,'(A14)')  'Monkhorst-pack'
        else
                write(19,'(A14)')   'Gamma-centered'
        endif
        write(19,'(3I3)') (kmesh(i), i=1,3)
        write(19,'(A9)') '  0  0  0'

        close(19)


        open(unit = 30, file = 'NEWKPT', status = 'unknown')

        write(30,'(A14)')  'Automatic mesh'
        write(30,'(A3)') '  0'
        if(kscheme.EQ.'m' .OR. kscheme.EQ.'M') then
                write(30,'(A14)')  'Monkhorst-pack'
        else
                write(30,'(A14)')   'Gamma-centered'
        endif
        write(30,'(3I3)') (kmesh(i), i=1,3)
        write(30,'(A9)') '  0  0  0'

        close(30)    

        end 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                       End of kpta.f                      %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        
