C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C--> subroutine "kptv" is used to create the KPOINTS file      %%%%
C--> according the "kspacing"                                  %%%%  
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        subroutine kptv(kspac, kscheme)

        double precision kspac
        character*1 kscheme

        double precision alat,pripos,privect
        dimension privect(3,3),pripos(1000,3)
        character*10 title,fix
        character*1 pricoord,seldyn
        character*5 sname
        character*10 inpos   
        dimension sname(10),fix(1000,3)
        integer i,j,k,ntype,natomi,nn
        integer Ncoord,Ndyn,atom_types,anum
        dimension natomi(10),atom_types(1000),anum(11) 
        
        integer imesh
        real, parameter:: PI=3.1415926      
        double precision proj 
        double precision recipvect, tempvect
        
        dimension proj(3), imesh(3), IS(3), JS(3)
        dimension recipvect(3,3), tempvect(3,3)

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%  1) kspac is the smalling allowed spacing between        %%%%
C%%%%     k-points in unit A^-1. The number of k-points        %%%%
C%%%%     increases when the spacing in decreased.             %%%%
C%%%%  2) kscheme specifies the type mesh to use: Gamma-       %%%%
C%%%%     centered or Monkorst-Pack. ("m" "M" or "g" "G")      %%%% 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        inpos='RECELL'

        call readpos(inpos,
     &               title, 
     &               alat,
     &               privect, 
     &               sname,
     &               natomi,                
     &               ntype,
     &               nn,  
     &               Ndyn,
     &               Ncoord,
     &               pripos,
     &               fix,
     &               atom_types)


        open(unit=19,position='Append',FILE='RELAS') 

        write(19,*) 'After reading, the three lattice vectors:'
        do i=1,3
           write(19,'(3f20.15)') (privect(i,j),j=1,3)
        enddo
        write(19,'(10A5)') (sname(i),i=1,ntype)
        write(19,'(10I4)') (natomi(i), i=1,ntype)

        write(19,*) '  -----------------------------------------'

        write(19,'(a26,a20,f8.4)') ' Smalling allowed spacing ',
     &                            'between k-points is ', kspac
        write(19,*) '  -----------------------------------------'

        close(19)
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%         define the reciprocal matrix of privect          %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do i=1,3
           do j=1,3
              tempvect(i,j)=privect(i,j)
           enddo
        enddo

        call brinv(tempvect,3,L,IS,JS)

        do i=1,3
           do j=1,3
              recipvect(i,j)=2*PI*tempvect(j,i)
           enddo
        enddo

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%             determin the proj(i) and imesh(i)            %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do i=1,3
           proj(i)=0.0000
           do j=1,3
              proj(i)=proj(i)+recipvect(i,j)*recipvect(i,j)
           enddo
           proj(i)=SQRT(proj(i))
        enddo
        
        do i=1,3
           imesh(i)=ceiling(proj(i)/kspac)

           if(imesh(i) .LE. 0) then
                   imesh(i)=1
           endif
        enddo

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                     Floor and Ceiling                    %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        if(kscheme.NE.'m' .AND. kscheme.NE.'g' 
     &     .AND. kscheme.NE.'M' .AND. kscheme.NE.'G') then
                open(unit=19,position='Append',FILE='RELAS') 
                write(19,*) 'Error!!! NOT "M" OR "G" FOR KSCHEME'
                close(19)
                stop
        endif

        if(kscheme.EQ.'m' .OR. kscheme.EQ.'M') then 
                do i=1,3
                   if( MOD(imesh(i),2) .EQ. 1 ) then
                           imesh(i)=imesh(i)+1
                   endif
                enddo
        endif

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                  writing the KPOINTS file                %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
        open(unit=19,position='Append',FILE='RELAS') 

        write(19,'(A14)')  'Automatic mesh'
        write(19,'(A3)') '  0'
        if(kscheme.EQ.'m' .OR. kscheme.EQ.'M') then
                write(19,'(A14)')  'Monkhorst-pack'
        else
                write(19,'(A14)')   'Gamma-centered'
        endif
        write(19,'(3I3)') (imesh(i), i=1,3)
        write(19,'(A9)') '  0  0  0'

        close(19)


        open(unit = 30, file = 'NEWKPT', status = 'unknown')

        write(30,'(A14)')  'Automatic mesh'
        write(30,'(A3)') '  0'
        if(kscheme.EQ.'m' .OR. kscheme.EQ.'M') then
                write(30,'(A14)')  'Monkhorst-pack'
        else
                write(30,'(A14)')   'Gamma-centered'
        endif
        write(30,'(3I3)') (imesh(i), i=1,3)
        write(30,'(A9)') '  0  0  0'

        close(30)

        end 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                     End of kptv.f                       %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
