!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!%%   Copyright[c] 2016-2017, S. H. Zhang and R. F. Zhang        %%
!%%   AELAS - an efficient open source command-line program for  %%
!%%           Automatic ELAStic constants derivations via        %%
!%%           high-throughput first principles computations.     %%
!%%           It is designed by Dr. S. H. Zhang and Prof.        %%
!%%           R. F. Zhang at Beihang University.                 %%
!%%                                                              %%
!%%   This program is free software: you can redistribute it     %%
!%%   and/or modify it under the terms of the BSD 3-Clause       %%
!%%   License as published by the Free Software Foundation,      %%
!%%   either version 3 of the License, or (at your option)       %%
!%%   any later version.                                         %%
!%%                                                              %%
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        module constant
                implicit none
                integer:: ndef=13

!       >>> Tolerance of distance between atomic positions and 
!           between lengths of lattice vectors to be tolerated 
!           in the symmetry finding.

                double precision:: symprec=0.01
                double precision,dimension(13):: defdata=(/-0.018, -0.015, -0.012, -0.009, -0.006, -0.003, 0.000, 0.003, 0.006, 0.009, 0.012, 0.015, 0.018/)
        end module constant


        program main

        integer i,j, kppra, pressure
        integer kmesh
        double precision kspac
        character*20 option, kscheme
        dimension kmesh(3)
        dimension option(20)


        call get_command_argument(1, option(1))
!        if (len_trim(option(1)) .EQ. 0) THEN
!                exit
!        endif


      if (option(1).EQ. '-g'.OR. option(1).EQ.'--generate') THEN
                call generate
      else if (option(1).EQ.'-d' .OR. option(1).EQ.'--derive') THEN
                call derive
      else if (option(1).EQ.'-e' .OR. option(1).EQ.'--extract') THEN
                call extract
      else if (option(1).EQ. '-g2d'.OR. option(1).EQ.'--generate2d') THEN
                call generate2d
      else if (option(1).EQ.'-d2d' .OR. option(1).EQ.'--derive2d') THEN
                call derive2d      
      else if (option(1).EQ.'-e2d' .OR. option(1).EQ.'--extract2d') THEN
                call extract2d              
!     else if (option(1).EQ.'t' .OR. option(1) .EQ. 'T') THEN
!               call AnisElas()                
      else if (option(1).EQ.'-i' .OR. option(1).EQ.'--incar') THEN
              call get_command_argument(2, option(2))
!             The default value of "pressure" is 0000
              if (len_trim(option(2)) .EQ. 0) THEN
                      pressure=0000
              else 
                      read(option(2),*) pressure
              endif                

!             Unit "GPa" --> "KBar"
              pressure=pressure*10
              call incarx(pressure)

      else if (option(1).EQ.'-v' .OR. option(1).EQ.'--version') THEN
              call version
      else if (option(1).EQ.'-h' .OR. option(1).EQ.'--help') THEN
              call help
      else if (option(1).EQ.'-c' .OR. option(1).EQ.'--clean') THEN
              call clean
      else if (option(1).EQ.'-l' .OR. option(1).EQ.'--license') THEN
              call license              
      else if (option(1).EQ.'-k' .OR. option(1).EQ.'--kmesh') THEN
              do i=2,4
                 call get_command_argument(i, option(i))
                 if (len_trim(option(i)) .EQ. 0) THEN
                         open(unit=19,position='Append',FILE='RELAS')
                         write(19,*) 'ERROR!! NOT SUCH INPUT OPTION!!!'
                         close(19)
                         stop
                 else 
                         read(option(i),*) kmesh(i-1)
                 endif
              enddo
              call get_command_argument(5, kscheme)
!             The default value of "kscheme" is Gamma 
              if (len_trim(kscheme) .EQ. 0) THEN
                      kscheme='Gamma'
              endif
              
              call kpt(kmesh,kscheme)

      else if (option(1).EQ.'-ka' .OR. option(1).EQ.'--kppra') THEN

              call get_command_argument(2, option(2))
!             The default value of "kppra" is 1000
              if (len_trim(option(2)) .EQ. 0) THEN
                      kppra=1000
              else 
                      read(option(2),*) kppra
              endif
                
              call get_command_argument(3, kscheme)
!             The default value of "kscheme" is Gamma                     
              if (len_trim(kscheme) .EQ. 0) THEN
                      kscheme='Gamma'
              endif
              
              call kpta(kppra, kscheme(1:1))

      else if (option(1).EQ.'-kv' .OR. option(1).EQ.'--kspac') THEN

              call get_command_argument(2, option(2))
!             The default value of "kspac" is 0.5
              if (len_trim(option(2)) .EQ. 0) THEN
                      kspac=0.5
              else 
                      read(option(2),*) kspac
              endif

              call get_command_argument(3, kscheme)
!             The default value of "kscheme" is Gamma                      
              if (len_trim(kscheme) .EQ. 0) THEN
                      kscheme='Gamma'
              endif

              call kptv(kspac, kscheme(1:1))

      else 
              open(unit=19,position='Append',FILE='RELAS')
              write(19,*) 'ERROR!! NOT SUCH INPUT OPTION!!!'
              close(19)
              stop
      endif        
        
      end
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!%%%%                       end of mian.f                      %%%%
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
