C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C--> Subroutine "provect" is used to transform the direction   %%%%
C--> of with Miller Index Z(pvh pvk pvl) and Y[uvu,uvv,uvw]    %%%%
C--> in order to calculate ideal strength of a crystal along   %%%%
C--> different direction based on projection method            %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
        subroutine provect(pvh,pvk,pvl,uvu,uvv,uvw,
     &                     privect, cosmat)
        double precision privect,strvect,cosmat
        double precision oldX,oldY,oldZ,newX,newY,newZ
        double precision matvect,matvectI
        integer pvh,pvk,pvl,uvu,uvv,uvw
        dimension privect(5,5),strvect(3,3),cosmat(3,3)
        dimension oldX(3),oldY(3),oldZ(3),newX(5),newY(5),newZ(5)
        dimension matvect(3,3),matvectI(3,3),recipvect(3,3)
        integer   i,j,k

C       >>> Two crystallographic directions
C        
C       the former: projection vector along Z axis that is normal
C                   to (pvh pvk pvl) plane      
C       the latter: upward vector along Y axis, .i.e [uvu uvv uvw] 
C
C       e.g. projection vector along Z axis is z[pvh pvk pvl]
C            upward vector along Y axis is     y[uvu uvv uvw]

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%                  Define the oldY and oldZ                %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        oldZ(1)=pvh
        oldZ(2)=pvk
        oldZ(3)=pvl
        oldY(1)=uvu
        oldY(2)=uvv
        oldY(3)=uvw
        oldX(1)=0.0
        oldX(2)=0.0
        oldX(3)=0.0

        if (oldZ(1)*oldY(1)+oldZ(2)*oldY(2)+oldZ(3)*oldY(3).NE.0) then
          open(unit=19,position='Append',FILE='RELAS') 
          write(19,*) '              >>>   ERROR!!!  <<<               '
          write(19,*) ' >> Upward vector is not in projected plane <<  '
          write(19,*) 'When the lattice vector [uvw] lies on the (hkl) '
          write(19,*) 'plane, u, v, w, h, k and l must satisfy the     '
          write(19,*) 'condition:                                      '
          write(19,*) '                 hu+kv+lw=0                     '
          write(19,*) 'This condition must, therefore, be satisfied in '
          write(19,*) 'order to specify the upward direction on the    '
          write(19,*) 'screen, otherwise the upward direction on the   '
          write(19,*) 'screen is automatically determined by this code.'
          close(19)
          stop
        endif

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%           define the reciprocal matrix of privect        %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do i=1,3
           do k=4,5
              privect(i,k)=privect(i,k-3)
           enddo
        enddo

        do i=4,5
           do k=1,5
              privect(i,k)=privect(i-3,k)
           enddo
        enddo
        
        do i=1,3
           do k=1,3
              recipvect(i,k)=privect(i+1,k+1)*privect(i+2,k+2)
     &                      -privect(i+1,k+2)*privect(i+2,k+1)
           enddo     
        enddo

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%           define the newY and newZ relative of XYZ       %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do i=1,3
           newZ(i)=0.0
           do j=1,3
              newZ(i)=newZ(i)+oldZ(j)*recipvect(j,i)
           enddo
        enddo

        do i=1,3
           newY(i)=0.0
           do j=1,3
              newY(i)=newY(i)+oldY(j)*privect(j,i)
           enddo
        enddo
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%             define the newX relative of XYZ              %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do k=4,5
           newY(k)=newY(k-3)
           newZ(k)=newZ(k-3)
        enddo

        do k=1,3
           newX(k)=newY(k+1)*newZ(k+2)-newZ(k+1)*newY(k+2)
        enddo
        
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%             define the transformation matrix             %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        do k=1,3
           matvect(1,k)=newX(k)/SQRT(newX(1)**2+newX(2)**2+newX(3)**2)
           matvect(2,k)=newY(k)/SQRT(newY(1)**2+newY(2)**2+newY(3)**2)
           matvect(3,k)=newZ(k)/SQRT(newZ(1)**2+newZ(2)**2+newZ(3)**2)
        enddo

C        write(*,*) 'Orientation matrix is as follows:'
C        do i=1,3
C           write(*,"(3f20.10)") (matvect(i,j),j=1,3)
C        enddo

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%             Transport the orientation matrix             %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

C       >>> matvectI=matvect^-1
C
C       "matvect" is a unitary matrix 
C       "matvectI" is equal to the transport matrix of "matvect" 
        do i=1,3
           do j=1,3
              matvectI(i,j)=matvect(j,i)
           enddo
        enddo

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%     To get new vect after the transform the direction    %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

C       To operate the lattice vectors by matrix
C       ---------------------------------------------
C             [a11 a12 a13]       [mat11 mat12 mat13]
C        R=   [a21 a22 a23]  MAT= [mat21 mat22 mat23]
C             [a31 a32 a33]       [mat31 mat32 mat33]
C       ---------------------------------------------
C             [aa11 aa12 aa13]
C        RR=  [aa21 aa22 aa23]
C             [aa31 aa32 aa33]
C       ---------------------------------------------
C        RR= R*MAT
C        Notice: aa11=a11*mat11+a12*mat21+a13*mat31
C                aa12=a11*mat12+a12*mat22+a13*mat32
C                aa13=a11*mat13+a12*mat23+a13*mat33
C        Notice: aa21=a21*mat11+a22*mat21+a23*mat31
C                aa22=a21*mat12+a22*mat22+a23*mat32
C                aa23=a21*mat13+a22*mat23+a23*mat33
C        Notice: aa31=a31*mat11+a32*mat21+a33*mat31
C                aa32=a31*mat12+a32*mat22+a33*mat32
C                aa33=a31*mat13+a32*mat23+a33*mat33
C       ---------------------------------------------
C        In VESTA, orientation is the inverse of MAT
C        i.e. the 1st row corresponds to mat11 mat21 mat31
C             the 1st col corresponds to mat11 mat12 mat13 
C       ---------------------------------------------
C 
C        For "matvect":  privect=strvect*matvect
C        For "matvectI": strvect=privect*matvectI       
C        

        do i=1,3
           do j=1,3
              strvect(i,j)=0.0
              do k=1,3
                 strvect(i,j)=strvect(i,j)+privect(i,k)*matvectI(k,j)
              enddo
           enddo 
        enddo  

C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%     To get the cosmat(i,j), which is the cosine of the   %%%% 
C%%%%     angle between the directions of X(i) and x(j)        %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        do i=1,3
           do j=1,3
              cosmat(i,j)=(strvect(i,1)*privect(j,1)+strvect(i,2)*
     &                     privect(j,2)+strvect(i,3)*privect(j,3))/
     &                     sqrt(strvect(i,1)**2+strvect(i,2)**2+
     &                     strvect(i,3)**2)/sqrt(privect(j,1)**2+
     &                     privect(j,2)**2+privect(j,3)**2)
           enddo
        enddo
        
        end
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%                      End of provect.f                   %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
          
