C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%   Subroutine "writepos" is used to write the structure   %%%%
C%%%%   file with format "VASP"                                %%%% 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine writepos(posmode,
     &                      outpos,                           
     &                      title, 
     &                      alat, 
     &                      privect, 
     &                      sname,
     &                      natomi,                
     &                      ntype,
     &                      nn,
     &                      Ndyn,
     &                      Ncoord,                
     &                      pripos,
     &                      fix,
     &                      atom_types)                

        double precision alat,pripos,privect
        dimension privect(3,3),pripos(1000,3)
        character*10 title,fix
        character*10 pricoord,seldyn
        character*5 sname
        character*15 outpos
        dimension sname(10),fix(1000,3)
        integer posmode
        integer i,j,k,ntype,natomi,nn
        integer Ncoord,Ndyn,atom_types,anum
        dimension natomi(10),atom_type(1000),anum(11)


C       posmode=00: Direct and selestive off
C       posmode=01: Direct and selestive on
C       posmode=10: Cartesian and selestive off
C       posmode=11: Cartesian and selestive on


        if (posmode .NE. 00 .AND. posmode .NE. 01 .AND.
     &      posmode .NE. 10 .AND. posmode .NE. 11) THEN
            
            open(unit=19,position='Append',FILE='RELAS')  
            write(19,*) "ERROR!! NO SUCH POSMODE WHEN WRITING POSCAR!!!"
            close(19)
            stop

        endif

        if (posmode .EQ. 00) then

                call directpos(atat,
     &                        privect,
     &                        nn,
     &                        Ncoord,
     &                        pripos)

                pricoord='Dirct'
                seldyn='Selective'

                open(unit = 30, file = Trim(outpos), status = 'unknown')
                write(30,'(A10)') title
                write(30,'(f12.10)') alat
                do i=1,3
                   write(30,"(3f20.10)")(privect(i,j),j=1,3)
                enddo
                write(30,'(10A5)') (sname(i),i=1,ntype)
                write(30,'(10I4)') (natomi(i), i=1,ntype)
                write(30,'(A6)') pricoord
                do i=1, nn
                   write(30,"(3f20.10)") (pripos(i,j),j=1,3)
                enddo
                close(30)                   
        endif
        

        if (posmode .EQ. 01) then

                call directpos(atat,
     &                        privect,
     &                        nn,
     &                        Ncoord,
     &                        pripos)

                pricoord='Dirct'
                seldyn='Selective'                

                open(unit = 30, file = Trim(outpos), status = 'unknown')
                write(30,'(A10)') title
                write(30,'(f12.10)') alat
                do i=1,3
                   write(30,"(3f20.10)")(privect(i,j),j=1,3)
                enddo
                write(30,'(10A5)') (sname(i),i=1,ntype)         
                write(30,'(10I4)') (natomi(i), i=1,ntype)
                write(30,'(A18)') 'Selective Dynamics'
                write(30,'(A6)') pricoord
                do i=1, nn
                   write(30,"(3f20.10,3A3)") (pripos(i,j),j=1,3),
     &                                       (fix(i,j),j=1,3)
                enddo 
                close(30)
        endif


        if (posmode .EQ. 10) then

                call cartepos(atat,
     &                        privect,
     &                        nn,
     &                        Ncoord,
     &                        pripos)
                
                pricoord='Cartesian'
                seldyn='Selective'

                open(unit = 30, file = Trim(outpos), status = 'unknown')
                write(30,'(A10)') title
                write(30,'(f12.10)') alat
                do i=1,3
                   write(30,"(3f20.10)")(privect(i,j),j=1,3)
                enddo
                write(30,'(10A5)') (sname(i),i=1,ntype)
                write(30,'(10I4)') (natomi(i), i=1,ntype)
                write(30,'(A6)') pricoord
                do i=1, nn
                   write(30,"(3f20.10)") (pripos(i,j),j=1,3)
                enddo
                close(30)                
        endif
        

        if (posmode .EQ. 11) then

                call cartepos(atat,
     &                        privect,
     &                        nn,
     &                        Ncoord,
     &                        pripos)

                pricoord='Cartesian'
                seldyn='Selective'

                open(unit = 30, file = Trim(outpos), status = 'unknown')
                write(30,'(A10)') title
                write(30,'(f12.10)') alat
                do i=1,3
                   write(30,"(3f20.10)")(privect(i,j),j=1,3)
                enddo
                write(30,'(10A5)') (sname(i),i=1,ntype)         
                write(30,'(10I4)') (natomi(i), i=1,ntype)
                write(30,'(A18)') 'Selective Dynamics'
                write(30,'(A6)') pricoord
                do i=1, nn
                   write(30,"(3f20.10,3A3)") (pripos(i,j),j=1,3),
     &                                       (fix(i,j),j=1,3)
                enddo 
                close(30)
        endif        

        end 
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C%%%%%%%%%                   End of writepos.f                 %%%%
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      
