% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[];
 
    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=[];
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=[];
    poisson_ratio=[];
 
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=1;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=[];
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.5;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[  0.0000,  1.0000, 0.5000];
    Xdist_range=[-50.0000, 50.0000, 0.0000];
    Xwid_range= [  0.0000,  5.0000, 1.0000];
    dx_range =  [ -5.0000,  5.0000, 0.0000];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='TRUE';
    
    % % The lattice matrix for pressure field
    
    pressfld_latxz=[];
    pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='TRUE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    eb_input=[];
    es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;
        
    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    wc_range=[];
      
    % % Concentration of solute atom
 
    solute_concentration=1;
