
% ------------------------------------------------------------------------
% Function: fitfuncABCx_1st( coef, ux )
% ------------------------------------------------------------------------
% Aim:
% 1/ The function of elastic resistance to fit the restoring force with
%    considering the first-order approximation in the trial function of 
%    disregistry vector
% ------------------------------------------------------------------------

function F_el = fitfuncABCx_1st( coef, ux )

    global BurVect Kx;
    global Nmis;

    Xcoef=coef(1:Nmis)/sum(coef(1:Nmis));
    if Nmis==1
        Xdist=0;
    elseif Nmis>=2
        Xdist=coef(Nmis+1:2*Nmis-1);
        Xdist(Nmis)=-sum(Xdist(1:Nmis-1));
    end
    Xwid=coef(2*Nmis:3*Nmis-1);
    Xalpha=coef(3*Nmis:4*Nmis-1);

    xxx=arrayfun(@(ux_i)fsolve(@(xx)BurVect*(1/2+1/pi*sum(Xcoef.*(atan((xx-Xdist)./Xwid)+(1-Xalpha).*Xwid.*(xx-Xdist)./((xx-Xdist).^2+(Xalpha.*Xwid).^2))))-ux_i,0, optimset('Display','off')),ux);

    F_el=zeros(size(xxx,1),1);

    for i=1:size(xxx,1)

        intfunc=@(x_t)arrayfun(@(x_t_i)(BurVect/pi)*(1./(xxx(i)-x_t_i))*sum(Xcoef.*(Xwid.*Xalpha./((x_t_i-Xdist).^2+(Xwid.*Xalpha).^2)+(1-Xalpha).*Xwid.*((Xalpha.*Xwid).^2-(x_t_i-Xdist).^2)./((Xalpha.*Xwid).^2+(x_t_i-Xdist).^2).^2)),x_t);

        F_el(i,1)=Kx/(2*pi)*(quadgk(intfunc,-inf,xxx(i)-1e-6,'RelTol',1e-8,'AbsTol',1e-12)+quadgk(intfunc,xxx(i)+1e-6,inf,'RelTol',1e-8,'AbsTol',1e-12));

    end  

end


