
% ------------------------------------------------------------------------
% Function: misfit_x ( x )
% ------------------------------------------------------------------------
% Aim:
% The disregistry vector along x axis
% ------------------------------------------------------------------------
% Ref:
% 1/ Schoeck, G. Philosophical Magazine A 69.6 (1994): 1085-1095.
% 2/ Schoeck, Gunther. Philosophical Magazine A 81.5 (2001): 1161-1176.
% ------------------------------------------------------------------------

function Ux = misfit_x(x)

    %   Defining global variables

    global Dx Wx Ax dx;
    global BurVect;
    global Nmis;

    % Some parameters
    
    if Nmis>=1
        
        % %   Some Matrix

        Xcoef=zeros(1,Nmis-1);
        Xdist=zeros(1,Nmis-1);
        Xwid=zeros(1,Nmis);
    
        for i=1:(Nmis-1)
            Xcoef(i)=Ax(i);
        end
    
        if Nmis==1
            Xcoef(Nmis)=1;
        else 
            Xcoef(Nmis)=1-sum(Xcoef(1:(Nmis-1)));
        end
    
        for i=1:Nmis-1
            Xdist(i)=Dx(i);
        end
    
        if Nmis==1
            Xdist(Nmis)=0;
        else 
            Xdist(Nmis)=0-sum(Xdist(1:(Nmis-1)));
        end
    
        for i=1:Nmis
            Xwid(i)=Wx(i);
        end
    
        temp=0;
        for m=1:Nmis
            temp=temp+BurVect/pi*Xcoef(m).*atan((x+Xdist(m))/Xwid(m));
        end

        Ux=temp+BurVect/2;        
    
    elseif Nmis==0

        Ux=BurVect/pi*(Ax*atan((x-Dx/2)/Wx)+(1-Ax)*atan((x+Dx/2)/Wx))+BurVect/2;

    elseif Nmis==-1
        
        Xcoef=[1/2*(1/2-Ax);Ax;1/2*(1/2-Ax);1/2*(1/2-Ax);Ax;1/2*(1/2-Ax)];
        Xdist=[Dx/2+dx;Dx/2;Dx/2-dx;-(Dx/2+dx);-Dx/2;-(Dx/2-dx)];
    
        temp=0;
        for m=1:6
            temp=temp+BurVect/pi*Xcoef(m).*atan((x+Xdist(m))/Wx);
        end

        Ux=temp+BurVect/2;

    end

end
