
% ------------------------------------------------------------------------
% Function: misfit_z ( x )
% ------------------------------------------------------------------------
% Aim:
% The disregistry vector along z axis
% ------------------------------------------------------------------------
% Ref:
% 1/ Schoeck, G. Philosophical Magazine A 69.6 (1994): 1085-1095.
% 2/ Schoeck, Gunther. Philosophical Magazine A 81.5 (2001): 1161-1176.
% ------------------------------------------------------------------------

function Uz = misfit_z(x)

    % Defining global variables

    global Dz Wz Az dz;
    global BurVect;
    global Nmis;
    
    if Nmis>=1
       
        % % Some Matrix

        Zcoef=zeros(1,Nmis-1);
        Zdist=zeros(1,Nmis-1);
        Zwid=zeros(1,Nmis);
    
        for i=1:(Nmis-1)
            Zcoef(i)=Az(i);
        end
    
        if Nmis==1
            Zcoef(Nmis)=0;
        else 
            Zcoef(Nmis)=0-sum(Zcoef(1:(Nmis-1)));
        end
    
        for i=1:Nmis-1
            Zdist(i)=Dz(i);
        end
    
        if Nmis==1
            Zdist(Nmis)=0;
        else 
            Zdist(Nmis)=0-sum(Zdist(1:(Nmis-1)));
        end
    
        for i=1:Nmis
            Zwid(i)=Wz(i);
        end
    
        temp=0;
        for m=1:Nmis
            temp=temp+BurVect/pi*Zcoef(m).*atan((x+Zdist(m))/Zwid(m));
        end

        Uz=temp;
    
    elseif Nmis==0
        
        Uz=BurVect/pi*(Az*atan((x-Dz/2)/Wz)+(-Az)*atan((x+Dz/2)/Wz)); 
    
    elseif Nmis==-1
            
        Zcoef=[1/2*(sqrt(3)/6-Az),Az,1/2*(sqrt(3)/6-Az),-1/2*(sqrt(3)/6-Az),-Az,-1/2*(sqrt(3)/6-Az)];
        Zdist=[Dz/2+dz,Dz/2,Dz/2-dz,-(Dz/2+dz),-Dz/2,-(Dz/2-dz)];
        Zwid=[Wz,Wz,Wz,Wz,Wz,Wz];
    
        temp=0;
        for n=1:6
            temp=temp+BurVect/pi*Zcoef(n).*atan((x+Zdist(n))/Zwid(n));
        end
    
        Uz=temp;
        
    end

end

