
% ------------------------------------------------------------------------
% Function: Einact ( Input )
% ------------------------------------------------------------------------
% Aim: 
% The solute/dislocation interaction energy
% ------------------------------------------------------------------------
% Ref:
% 1/ Ma D, Frik M, von Pezold J, et al. Acta Materialia, 2015, 85: 53-66.
% ------------------------------------------------------------------------

function Einact = Einact( xx, yy, eb, es )

    % define global variables

        global BurVect LatC_spacing;
        global coefV;

    % volumetric misfit interaction energy Evolume

        % % extra volume introduced by the solute atom in the matrix

        dV=coefV*eb;

        % % pressure field produced by the dislocation
        
        pressfld_Einact=pressfield_Einact(xx,yy);

        % % volumetric misfit interaction energy Evolume
        
        Evolume=-pressfld_Einact*dV;

    % slip misfit interaction energy

        % % the area occpupied by one atom on the slip plane

        Aa=sqrt(3)/2*BurVect^2;

        % % gamma surface "Ga" of pure metal

        function [ GammaSFE ]=GammaSFE( xg,yg )

            if abs(yg) < LatC_spacing
                GammaSFE=Gamma(xg);
            else
                GammaSFE=0;
            end

        end

        % % slip misfit interaction energy

        Eslip=Aa*GammaSFE(xx,yy)*es;

    % dislocation-solute interaction energy( 1E-20*J )
    
        Einact=Evolume/10+Eslip;
        
end
