
% ------------------------------------------------------------------------
% Function: Etotal( w )
% ------------------------------------------------------------------------
% Aim: 
% The total energy change
% ------------------------------------------------------------------------
% Ref:
% 1/ Leyson, G. P. M., L. G. Hector, and W. A. Curtin. Acta Materialia 60.13 (2012): 5197-5203.
% 2/ Leyson, G. P. M., L. G. Hector, and W. A. Curtin. Acta Materialia 60.9 (2012): 3873-3884.
% ------------------------------------------------------------------------

function [ Etot ] = Etotal( w )

    % define global variables

        global solute_concentration LT;
        global BurVect;

    % length of dislocation, whose value does not impact on the result (m)

        dis_length=100;

    % characteristic segment length

        % Zetac=(4*sqrt(3)*LT^2*w^4*BurVect/(solute_concentration*Epoten(w)^2))^(1/3);

    % % total energy change (1E-10*J) as a straight dislocation bows out

        % Etot=(LT*w^2/(2*Zetac)-sqrt(solute_concentration*Zetac/(sqrt(3)*BurVect))*Epoten(w))*(dis_length/(2*Zetac));

        Etot=-3^(2/3)/2^(10/3)*(solute_concentration^2*Epoten(w)^4/(BurVect^2*w^2*LT))^(1/3)*dis_length;

end

